package com.yy.platform.loginlite;


import com.dw.android.itna.DwItna;
import com.google.protobuf.ByteString;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeReq;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeReqHw;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeRspHw;
import com.yy.platform.loginlite.proto.AntiVerifySdkResultReq;
import com.yy.platform.loginlite.proto.AntiVerifySdkResultReqHw;
import com.yy.platform.loginlite.proto.AntiVerifySdkResultRsp;
import com.yy.platform.loginlite.proto.AntiVerifySdkResultRspHw;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AntiHelper {
    private static Executor executor;

    private static final int SUCCESS = 200;
    private static final int TIMEOUT = 10 * 1000;
    private static final int count = 3;

    private static Executor getExecutor() {
        if (executor == null) {
            synchronized (AntiHelper.class) {
                if (executor == null) {
                    executor = new ThreadPoolExecutor(1, 2,
                            5, TimeUnit.SECONDS,
                            new LinkedBlockingQueue<Runnable>());
                }
            }
        }
        return executor;
    }

    public static int checkAntiCode(final long yyuid) {
        if (AuthInfo.isOverseas()) {
            return checkAntiCodeHwHttp(yyuid);
        } else {
            return checkAntiCodeCn(yyuid);
        }
    }

    private static void runAntiCodeHwHttp(final long yyuid, final byte[] code) {
        final String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            LoginLog.i("no anti bizName for run overseas anticodeHw");
            return;
        }
        getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                DwItna.setUdbId(AuthInfo.getHeader().getDeviceId());
                byte[] execCode = DwItna.exec(AuthInfo.getAppContext(),
                        code == null ? "".getBytes() : code,
                        AuthInfo.getAppId(), 0);
                byte[] token = AuthInfo.getServiceOtp(yyuid);
                AntiVerifySdkResultReqHw req = AntiVerifySdkResultReqHw.newBuilder()
                        .setBizName(bizName)
                        .setUid(yyuid)
                        .setResult(ByteString.copyFrom(execCode == null ? "".getBytes() : execCode))
                        .setIp(0)
                        .setTokenType(0)
                        .setToken(ByteString.copyFrom(token == null ? "".getBytes() : token))
                        .build();

                final String serverName = "svc_anti_codegetverify_service_hw";
                final String funcName = "AntiVerifySdkResultReqHw";

                final String traceId = UUID.randomUUID().toString();
                HttpURLConnection conn = null;
                final String url = ServerUrls.getHttpUrl() + serverName + "/" + funcName;
                LoginLog.i("run overseas verify http yyuid:" + yyuid + ", traceId: " + traceId
                        + ", url: " + url);
                try {
                    URL httpURL = new URL(url);
                    conn = (HttpURLConnection) httpURL.openConnection();
                    conn.setRequestMethod(ServerUrls.POST);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setConnectTimeout(TIMEOUT);

                    conn.addRequestProperty("Context", funcName);
                    conn.addRequestProperty("AppId", AuthInfo.getAppId());
                    conn.addRequestProperty("Uid", String.valueOf(yyuid));
                    conn.addRequestProperty("ServiceName", serverName);
                    conn.addRequestProperty("FunctionName", funcName);
                    conn.addRequestProperty("TraceId", traceId);
                    // conn.addRequestProperty("Content-Type", "application/yyrpc-pb");
                    conn.addRequestProperty("ProtoType", "http");
                    conn.addRequestProperty("InstId", funcName);
                    conn.addRequestProperty("ServerId", funcName);

                    OutputStream os = conn.getOutputStream();
                    req.writeTo(os);
                    conn.connect();

                    int code = conn.getResponseCode();
                    LoginLog.i("run overseas verify http code: " + code);
                    if (code == SUCCESS) {
                        AntiVerifySdkResultRspHw res = AntiVerifySdkResultRspHw.newBuilder()
                                .mergeFrom(conn.getInputStream()).build();
                        if (res != null) {
                            LoginLog.i("run overseas verify http success, res = " +
                                    res.getRes());
                        } else {
                            LoginLog.i("run overseas verify http fail");
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                    String errInfo = "run overseas verify http, connect exception:" + e.getMessage();
                    LoginLog.i(errInfo);
                } finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        });
    }

    private static int checkAntiCodeHwHttp(final long yyuid) {
        String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            LoginLog.i("no anti_hw bizName for check overseas anticode");
            return -1;
        }
        final AntiGetSdkCodeReqHw req = AntiGetSdkCodeReqHw.newBuilder()
                .setBizName(bizName)
                .setUid(yyuid)
                .setIp(0)
                .build();
        final String serverName = "svc_anti_codegetverify_service_hw";
        final String funcName = "AntiGetSdkCodeReqHw";

        getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < count; i++) {
                    final String traceId = UUID.randomUUID().toString();
                    HttpURLConnection conn = null;
                    final String url = ServerUrls.getHttpUrl() + serverName + "/" + funcName;
                    LoginLog.i("get overseas verify http,yyuid:" + yyuid +
                            ", traceId: " + traceId + ", url: " + url);
                    try {
                        URL httpURL = new URL(url);
                        conn = (HttpURLConnection) httpURL.openConnection();
                        conn.setRequestMethod(ServerUrls.POST);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setConnectTimeout(TIMEOUT);

                        conn.addRequestProperty("Context", funcName);
                        conn.addRequestProperty("AppId", AuthInfo.getAppId());
                        conn.addRequestProperty("Uid", String.valueOf(yyuid));
                        conn.addRequestProperty("ServiceName", serverName);
                        conn.addRequestProperty("FunctionName", funcName);
                        conn.addRequestProperty("TraceId", traceId);
                        conn.addRequestProperty("ProtoType", "http");
                        conn.addRequestProperty("InstId", funcName);
                        conn.addRequestProperty("ServerId", funcName);

                        OutputStream os = conn.getOutputStream();
                        req.writeTo(os);
                        conn.connect();

                        int code = conn.getResponseCode();
                        LoginLog.i("get overseas verify http, code: " + code);
                        if (code == SUCCESS) {
                            AntiGetSdkCodeRspHw res = AntiGetSdkCodeRspHw.newBuilder().
                                    mergeFrom(conn.getInputStream()).build();
                            if (res != null) {
                                LoginLog.i("get overseas verify http success");
                                //执行反外挂码
                                ByteString codeByte = res.getCode();
                                runAntiCodeHwHttp(res.getUid(),
                                        codeByte == null ? "".getBytes() : codeByte.toByteArray());
                                break;
                            } else {
                                LoginLog.i("get overseas verify http fail");
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        String errInfo = "get overseas verify http, connect exception, " + e.getMessage();
                        LoginLog.i(errInfo);
                    } finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }
        });
        return 1;
    }

    private static int checkAntiCodeCn(final long yyuid) {
        String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            LoginLog.i("no anti bizName for check china anticode");
            return -1;
        }
        final AntiGetSdkCodeReq req = AntiGetSdkCodeReq.newBuilder()
                .setBizName(bizName)
                .setUid(yyuid)
                .setIp(0)
                .build();

        final String serverName = "svc_anti_codegetverify";
        final String funcName = "AntiGetSdkCodeReq";

        getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < count; i++) {
                    final String traceId = UUID.randomUUID().toString();
                    HttpURLConnection conn = null;
                    final String url = ServerUrls.getHttpUrl() + serverName + "/" + funcName;
                    LoginLog.i("get china verify http,yyuid:" + yyuid + ", traceId: " +
                            traceId + ", url: " + url);
                    try {
                        URL httpURL = new URL(url);
                        conn = (HttpURLConnection) httpURL.openConnection();
                        conn.setRequestMethod(ServerUrls.POST);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setConnectTimeout(TIMEOUT);

                        conn.addRequestProperty("Context", funcName);
                        conn.addRequestProperty("AppId", AuthInfo.getAppId());
                        conn.addRequestProperty("Uid", String.valueOf(yyuid));
                        conn.addRequestProperty("ServiceName", serverName);
                        conn.addRequestProperty("FunctionName", funcName);
                        conn.addRequestProperty("TraceId", traceId);
                        conn.addRequestProperty("ProtoType", "http");
                        conn.addRequestProperty("InstId", funcName);
                        conn.addRequestProperty("ServerId", funcName);

                        OutputStream os = conn.getOutputStream();
                        req.writeTo(os);
                        conn.connect();

                        int code = conn.getResponseCode();
                        LoginLog.i("get china verify http, code: " + code);
                        if (code == SUCCESS) {
                            AntiGetSdkCodeRspHw res = AntiGetSdkCodeRspHw.newBuilder().
                                    mergeFrom(conn.getInputStream()).build();
                            if (res != null) {
                                LoginLog.i("get china verify http success");
                                //执行反外挂码
                                ByteString codeByte = res.getCode();
                                runAntiCodeCn(res.getUid(),
                                        codeByte == null ? "".getBytes() : codeByte.toByteArray());
                                break;
                            } else {
                                LoginLog.i("get china verify http fail");
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        String errInfo = "get china verify http, connect exception, " + e.getMessage();
                        LoginLog.i(errInfo);
                    } finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }
        });

        return 1;
    }

    private static int runAntiCodeCn(final long yyuid, final byte[] code) {
        final String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            LoginLog.i("no anti bizName for run china anticode");
            return -1;
        }
        getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                DwItna.setUdbId(AuthInfo.getHeader().getDeviceId());

                byte[] execCode = DwItna.exec(AuthInfo.getAppContext(),
                        code == null ? "".getBytes() : code,
                        AuthInfo.getAppId(), 0);
                byte[] token = AuthInfo.getServiceOtp(yyuid);
                AntiVerifySdkResultReq req = AntiVerifySdkResultReq.newBuilder()
                        .setBizName(bizName)
                        .setUid(yyuid)
                        .setResult(ByteString.copyFrom(execCode == null ? "".getBytes() : execCode))
                        .setIp(0)
                        .setTokenType(0)
                        .setToken(ByteString.copyFrom(token == null ? "".getBytes() : token))
                        .build();
                final String serverName = "svc_anti_codegetverify";
                final String funcName = "AntiVerifySdkResultReq";

                final String traceId = UUID.randomUUID().toString();
                HttpURLConnection conn = null;
                final String url = ServerUrls.getHttpUrl() + serverName + "/" + funcName;
                LoginLog.i("run china verify http, yyuid:" + yyuid + ", traceId: " + traceId
                        + ", url: " + url);
                try {
                    URL httpURL = new URL(url);
                    conn = (HttpURLConnection) httpURL.openConnection();
                    conn.setRequestMethod(ServerUrls.POST);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setConnectTimeout(TIMEOUT);

                    conn.addRequestProperty("Context", funcName);
                    conn.addRequestProperty("AppId", AuthInfo.getAppId());
                    conn.addRequestProperty("Uid", String.valueOf(yyuid));
                    conn.addRequestProperty("ServiceName", serverName);
                    conn.addRequestProperty("FunctionName", funcName);
                    conn.addRequestProperty("TraceId", traceId);
                    // conn.addRequestProperty("Content-Type", "application/yyrpc-pb");
                    conn.addRequestProperty("ProtoType", "http");
                    conn.addRequestProperty("InstId", funcName);
                    conn.addRequestProperty("ServerId", funcName);

                    OutputStream os = conn.getOutputStream();
                    req.writeTo(os);
                    conn.connect();

                    int code = conn.getResponseCode();
                    LoginLog.i("run china verify http, code: " + code);
                    if (code == SUCCESS) {
                        AntiVerifySdkResultRsp res = AntiVerifySdkResultRsp.newBuilder()
                                .mergeFrom(conn.getInputStream()).build();
                        if (res != null) {
                            LoginLog.i("run china verify http success,antiVerifyResCode=" +
                                    res.getRes());
                        } else {
                            LoginLog.i("run china verify http fail");
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                    String errInfo = "run china verify http, connector exception:" + e.getMessage();
                    LoginLog.i(errInfo);
                } finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        });
        return 0;
    }
}
