/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite.utils;

import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.yy.platform.loginlite.ALog;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadManager {
    private static Handler mManinHandler;
    private static final int NUM = 2;
    protected static volatile Executor NETWORK_EXECUTOR;

    private static Executor initNetworkExecutor() {
        Executor executor;
        if (Build.VERSION.SDK_INT >= 11) {
            LinkedBlockingQueue<Runnable> linkedBlockingQueue;
            ThreadPoolExecutor threadPoolExecutor;
            executor = threadPoolExecutor;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
            linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
            threadPoolExecutor = new ThreadPoolExecutor(2, 2, 0L, timeUnit, linkedBlockingQueue2);
        } else {
            try {
                Field field = AsyncTask.class.getDeclaredField("sExecutor");
                field.setAccessible(true);
                executor = (Executor)field.get(null);
            }
            catch (Exception exception) {
                LinkedBlockingQueue<Runnable> linkedBlockingQueue;
                ThreadPoolExecutor threadPoolExecutor;
                executor = threadPoolExecutor;
                TimeUnit timeUnit = TimeUnit.SECONDS;
                LinkedBlockingQueue<Runnable> linkedBlockingQueue3 = linkedBlockingQueue;
                linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
                threadPoolExecutor = new ThreadPoolExecutor(2, 2, 0L, timeUnit, linkedBlockingQueue3);
            }
        }
        if (executor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)executor).setCorePoolSize(2);
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (NETWORK_EXECUTOR != null) return;
        Class<ThreadManager> clazz = ThreadManager.class;
        synchronized (ThreadManager.class) {
            if (NETWORK_EXECUTOR != null) return;
            NETWORK_EXECUTOR = ThreadManager.initNetworkExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getMainHandler() {
        if (mManinHandler != null) return mManinHandler;
        Class<ThreadManager> clazz = ThreadManager.class;
        synchronized (ThreadManager.class) {
            if (mManinHandler != null) return mManinHandler;
            mManinHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mManinHandler;
        }
    }

    public static void executeOnMainThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        ThreadManager.getMainHandler().postAtFrontOfQueue(runnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void executeOnNetWorkThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        try {
            if (NETWORK_EXECUTOR == null) {
                NETWORK_EXECUTOR = ThreadManager.initNetworkExecutor();
            }
            NETWORK_EXECUTOR.execute(runnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            ALog.i("ex:" + rejectedExecutionException.getLocalizedMessage());
        }
    }

    public static void executeOnSubThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        new Thread(runnable).start();
    }

    public static void executeOnSubThread(Runnable runnable, long l) {
        a a2;
        if (runnable == null) {
            return;
        }
        a a3 = a2;
        a3(runnable);
        ThreadManager.getMainHandler().postDelayed((Runnable)a2, l);
    }
}

