/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.AuthInfo;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.internal.http2.ConnectionShutdownException;

public class NetworkUtil {
    private static final int WIFI = 100010;
    private static final int NET_2G = 100020;
    private static final int NET_3G = 100030;
    private static final int NET_4G = 100040;

    public static boolean isNetworkConnected() {
        if (AuthInfo.getAppContext() == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)AuthInfo.getAppContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        if ((connectivityManager = connectivityManager.getActiveNetworkInfo()) == null) {
            return false;
        }
        if (connectivityManager.isConnected()) {
            return true;
        }
        return connectivityManager.isAvailable() && connectivityManager.isConnectedOrConnecting();
    }

    public static boolean isNetworkConnected2() {
        return NetworkUtil.isNetworkConnected2(AuthInfo.getAppContext());
    }

    public static boolean isNetworkConnected2(Context context) {
        block7: {
            context = (ConnectivityManager)context.getSystemService("connectivity");
            if (context == null) break block7;
            context = context.getActiveNetworkInfo();
            if (context == null) break block7;
            if (context.getState() == null) break block7;
            NetworkInfo.State state = context.getState();
            try {
                ALog.i("isNetworkConnected2 Network value is " + context.getType() + ",state=" + state);
                if (state == NetworkInfo.State.CONNECTED) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                ALog.i("Network ex:" + throwable.getMessage());
            }
        }
        return false;
    }

    public static int getTimeout(Context context) {
        block15: {
            int n;
            block16: {
                context = (ConnectivityManager)context.getSystemService("connectivity");
                if (context == null) break block15;
                context = context.getActiveNetworkInfo();
                if (context == null) break block15;
                if (context.getState() == null) break block15;
                NetworkInfo.State state = context.getState();
                ALog.i("Network value is " + context.getType() + ",state=" + state);
                if (state != NetworkInfo.State.CONNECTED) break block15;
                n = NetworkUtil.getNetworkType((NetworkInfo)context);
                if (n != 100010) break block16;
                ALog.i("Network is TYPE_WIFI");
                return 7000;
            }
            if (n == 100040) {
                ALog.i("Network is TYPE_MOBILE");
                return 9000;
            }
            if (n == 100030) {
                ALog.i("Network is 3G");
                return 12000;
            }
            if (n == 100020) {
                ALog.i("Network is 2G");
                return 15000;
            }
            try {
                ALog.i("Network is " + context.getType());
                return 15000;
            }
            catch (Throwable throwable) {
                ALog.i("Network ex:" + throwable.getMessage());
            }
        }
        return 10000;
    }

    public static int getTimeout2(Context context) {
        block12: {
            int n;
            block13: {
                context = (ConnectivityManager)context.getSystemService("connectivity");
                if (context == null) break block12;
                context = context.getActiveNetworkInfo();
                if (context == null) break block12;
                n = NetworkUtil.getNetworkType((NetworkInfo)context);
                if (n != 100010) break block13;
                ALog.i("Network is TYPE_WIFI");
                return 7000;
            }
            if (n == 100040) {
                ALog.i("Network is TYPE_MOBILE");
                return 9000;
            }
            if (n == 100030) {
                ALog.i("Network is 3G");
                return 12000;
            }
            if (n == 100020) {
                ALog.i("Network is 2G");
                return 15000;
            }
            try {
                ALog.i("Network is " + context.getType());
                return 15000;
            }
            catch (Throwable throwable) {
                ALog.i("Network ex:" + throwable.getMessage());
            }
        }
        return 10000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getNetworkType(NetworkInfo networkInfo) {
        if (networkInfo == null) return -100;
        int n = networkInfo.getType();
        if (n == 1 || n == 6) return 100010;
        if (n != 0) return -100;
        int n2 = networkInfo.getSubtype();
        if (n2 == 7 || n2 == 3 || n2 == 14 || n2 == 5 || n2 == 6 || n2 == 12 || n2 == 8 || n2 == 10 || n2 == 15 || n2 == 9) return 100030;
        if (n2 == 1 || n2 == 4 || n2 == 2 || n2 == 11) return 100020;
        if (n2 != 13) return -100;
        return 100040;
    }

    public static int getErrorCodeByExc(Throwable throwable) {
        int n = 0;
        if (throwable != null) {
            if (!NetworkUtil.isNetworkConnected2()) {
                n = 14;
            } else if (throwable instanceof SocketTimeoutException) {
                n = 1;
            } else if (throwable instanceof UnknownHostException) {
                n = 2;
            } else if (throwable instanceof ConnectException) {
                n = 3;
            } else if (throwable instanceof SocketException) {
                n = 4;
            } else if (throwable instanceof NoRouteToHostException) {
                n = 7;
            } else if (throwable instanceof SSLPeerUnverifiedException) {
                n = 5;
            } else if (throwable instanceof SSLHandshakeException) {
                n = 6;
            } else if (throwable instanceof ConnectionShutdownException) {
                n = 8;
            } else if (throwable instanceof IOException) {
                n = 9;
            }
        }
        return n;
    }

    public static class NetErrorType {
        public static final int NATIVE_NOT_NORMAL_EXCEPTION = 0;
        public static final int SocketTimeout = 1;
        public static final int UnknownHost = 2;
        public static final int Connect = 3;
        public static final int SocketException = 4;
        public static final int SSLPeerUnverified = 5;
        public static final int SSLHandshake = 6;
        public static final int NoRouteToHost = 7;
        public static final int ConnectionShutdown = 8;
        public static final int IOException = 9;
        public static final int CANCEL = 10;
        public static final int DataError = 11;
        public static final int Timeout = 12;
        public static final int NoImportantData = 13;
        public static final int NO_NET = 14;
        public static final int WS_NOT_CONNECT = 15;
        public static final int NO_URL = 16;
        public static final int JSON = 17;
    }
}

