/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite;

import android.content.SharedPreferences;
import com.yy.platform.loginlite.ALog;

public class NetworkStrategy {
    private static volatile NetworkStrategy instance;
    public static final String KEY_SUM = "network_sum";
    public static final String KEY_RESULT = "network_result";
    public static final String KEY_TIME = "now";
    private static final long MONTH = 2592000L;
    private static final long count = 3L;
    private SharedPreferences preferences;
    private volatile int isQuicStatus = 0;
    private volatile int isHttpStatus = 0;
    private volatile long quicTime = 0L;
    private volatile long httpTime = 0L;

    private NetworkStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkStrategy getInstance() {
        if (instance != null) return instance;
        Class<NetworkStrategy> clazz = NetworkStrategy.class;
        synchronized (NetworkStrategy.class) {
            if (instance != null) return instance;
            instance = new NetworkStrategy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void evaluate() {
        if (this.isQuicStatus != 0 && this.isHttpStatus != 0 && this.quicTime != 0L && this.httpTime != 0L) {
            int n;
            ALog.e("start evaluate... quic=" + this.isQuicStatus + ", http=" + this.isHttpStatus + ", quic time=" + this.quicTime + ", http time=" + this.httpTime);
            if (!(this.isHttpStatus != 1 || this.isQuicStatus != 1 ? this.isHttpStatus == 1 && this.isQuicStatus == -1 || this.isHttpStatus != -1 || this.isQuicStatus != 1 : this.quicTime > this.httpTime)) {
                ALog.e("choice quic");
                n = -1;
            } else {
                ALog.e("choice http");
                n = 1;
            }
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences != null) {
                int n2 = sharedPreferences.getInt(KEY_SUM, 0);
                if ((long)n2 == 3L) {
                    return;
                }
                int n3 = this.preferences.getInt(KEY_RESULT, 0);
                n = n3 + n;
                int n4 = n2 + 1;
                ALog.e("old sum=" + n2 + ",value=" + n3 + ", new sum=" + n4 + ",value=" + n);
                SharedPreferences.Editor editor = this.preferences.edit();
                if ((long)n4 == 3L) {
                    long l = System.currentTimeMillis();
                    editor.putLong(KEY_TIME, l);
                }
                SharedPreferences.Editor editor2 = editor;
                editor2.putInt(KEY_SUM, n4);
                editor2.putInt(KEY_RESULT, n);
                editor2.commit();
            }
            this.reset();
        }
    }

    private void reset() {
        NetworkStrategy networkStrategy = this;
        networkStrategy.isQuicStatus = 0;
        networkStrategy.isHttpStatus = 0;
        networkStrategy.quicTime = 0L;
        networkStrategy.httpTime = 0L;
    }

    public void setPreferences(SharedPreferences sharedPreferences) {
        this.preferences = sharedPreferences;
    }

    public void setHttpStatus(boolean n) {
        n = n != 0 ? 1 : -1;
        this.isHttpStatus = n;
        this.evaluate();
    }

    public void setHttpTime(long l) {
        this.httpTime = l;
        this.evaluate();
    }

    public void setQuicStatus(boolean n) {
        n = n != 0 ? 1 : -1;
        this.isQuicStatus = n;
        this.evaluate();
    }

    public void setQuicTime(long l) {
        this.quicTime = l;
        this.evaluate();
    }

    public int[] getResult() {
        SharedPreferences sharedPreferences = this.preferences;
        if (sharedPreferences != null) {
            int n = sharedPreferences.getInt(KEY_RESULT, 0);
            int n2 = this.preferences.getInt(KEY_SUM, 0);
            return new int[]{n2, n};
        }
        return new int[]{0, 0};
    }

    public long getTime() {
        NetworkStrategy networkStrategy = networkStrategy.preferences;
        if (networkStrategy != null) {
            return networkStrategy.getLong(KEY_TIME, 0L);
        }
        return 0L;
    }

    public boolean[] choiceStrategy() {
        NetworkStrategy networkStrategy = this;
        int[] nArray = networkStrategy.getResult();
        long l = networkStrategy.getTime();
        long l2 = System.currentTimeMillis() - l;
        ALog.e("credit sum=" + nArray[0] + " value=" + nArray[1] + " " + l);
        if (l > 0L && l2 / 1000L >= 2592000L) {
            this.clear();
        }
        boolean bl = true;
        boolean bl2 = true;
        if ((long)nArray[0] == 3L) {
            if (nArray[1] > 0) {
                bl2 = false;
            } else if (nArray[1] < 0) {
                bl = false;
            }
        }
        return new boolean[]{bl, bl2};
    }

    public void clear() {
        NetworkStrategy networkStrategy = networkStrategy.preferences;
        if (networkStrategy != null) {
            SharedPreferences.Editor editor = networkStrategy.edit();
            editor.putLong(KEY_TIME, 0L);
            editor.putInt(KEY_RESULT, 0);
            editor.putInt(KEY_SUM, 0);
            editor.commit();
        }
    }
}

