/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.AuthCore;

public class NetworkReceiver
extends BroadcastReceiver {
    private int mLastNetworkStatus = -100;
    private long mLastNetworkChangedTs = 0L;
    private int mNetworkChangedCount = 0;
    private int mNetworkState = -100;
    private Context mAppContext = null;

    public NetworkReceiver(Context context) {
        this.mAppContext = context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkNetwork(Context context) {
        block9: {
            NetworkInfo.State state;
            try {
                context = (ConnectivityManager)context.getSystemService("connectivity");
                if (context == null) break block9;
            }
            catch (Throwable throwable) {
                ALog.i("Network ex:" + throwable.getMessage());
                break block9;
            }
            {
                context = context.getActiveNetworkInfo();
            }
            {
                if (context == null || context.getState() == null) break block9;
                state = context.getState();
            }
            {
                this.mNetworkState = state.ordinal();
                ALog.i("Network value is " + context.getType() + ",state=" + state);
                if (state != NetworkInfo.State.CONNECTED) break block9;
            }
            {
                if (this.mLastNetworkStatus == context.getType()) {
                    ALog.i("Network type not changed:" + this.mLastNetworkStatus);
                    return;
                }
                if (context.getType() == 1) {
                    ALog.i("Network is TYPE_WIFI");
                    this.mLastNetworkStatus = 1;
                    return;
                }
                if (context.getType() == 0) {
                    ALog.i("Network is TYPE_MOBILE");
                    this.mLastNetworkStatus = 0;
                    return;
                }
                ALog.i("Network is :" + context.getType());
                this.mLastNetworkStatus = context.getType();
                return;
            }
        }
        NetworkReceiver networkReceiver = this;
        networkReceiver.mNetworkState = -1;
        networkReceiver.mLastNetworkStatus = -1;
        ALog.i("Network is invalidate");
    }

    public int getNetWorkType() {
        if (this.mLastNetworkStatus == -100) {
            NetworkReceiver networkReceiver = this;
            networkReceiver.checkNetwork(networkReceiver.mAppContext);
        }
        return this.mLastNetworkStatus;
    }

    public int checkCurrentNetwork() {
        int n;
        block7: {
            block8: {
                NetworkReceiver networkReceiver = this;
                n = networkReceiver.mLastNetworkStatus;
                ConnectivityManager connectivityManager = (ConnectivityManager)networkReceiver.mAppContext.getSystemService("connectivity");
                if (connectivityManager == null) break block7;
                connectivityManager = connectivityManager.getActiveNetworkInfo();
                if (connectivityManager == null) break block7;
                if (connectivityManager.getState() == null) break block7;
                this.mNetworkState = connectivityManager.getState().ordinal();
                n = connectivityManager.getType();
                if (n == this.mLastNetworkStatus) break block8;
                try {
                    ALog.i("Network state type changed,previous status:" + this.mLastNetworkStatus + ",now status:" + n);
                }
                catch (Throwable throwable) {
                    ALog.i("Network state ex:" + throwable.getMessage());
                }
            }
            return n;
        }
        this.mNetworkState = -1;
        ALog.i("Network state is invalidate,last type:" + n);
        return n;
    }

    public int getNetWorkState() {
        return this.mNetworkState;
    }

    public int getNetworkChangedCount() {
        return this.mNetworkChangedCount;
    }

    public long getLastNetworkChangedTs() {
        return this.mLastNetworkChangedTs;
    }

    public void onReceive(Context context, Intent intent) {
        int n = this.mLastNetworkStatus;
        NetworkReceiver networkReceiver = this;
        networkReceiver.checkNetwork(context);
        if (n != networkReceiver.mLastNetworkStatus) {
            AuthCore.LogWrapper.i("authsdk", "Network type changed from:" + n + " to:" + this.mLastNetworkStatus);
            ++this.mNetworkChangedCount;
            this.mLastNetworkChangedTs = System.currentTimeMillis() / 1000L;
        }
    }
}

