/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite;

import android.os.Handler;
import android.os.Looper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.AntiHelper;
import com.yy.platform.loginlite.AuthInfo;
import com.yy.platform.loginlite.CHidoReport;
import com.yy.platform.loginlite.ICreditLoginCallback;
import com.yy.platform.loginlite.ITask;
import com.yy.platform.loginlite.NextVerify;
import com.yy.platform.loginlite.YYInfo;
import com.yy.platform.loginlite.proto.CreditLoginReq;
import com.yy.platform.loginlite.proto.CreditLoginRsp;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.ProtoHeader;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.HttpClient;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CreditLoginHttp1
implements ICreditLoginCallback,
ITask {
    private static final String fun = "CreditLogin using http ";
    private static final int RETRY = 3;
    private static final int DURATION = 30000;
    private CreditLoginReq creditLoginReq;
    private String url;
    private Map<String, String> headers;
    private volatile int index;
    private long yyuid;
    private long startTime;
    private Lock callbackLock;
    private volatile ICreditLoginCallback callback;
    private String traceId;
    private int httpResult;
    private volatile boolean isStop;
    private Handler mHandler;
    private volatile int networkError;
    private int timeout;

    public CreditLoginHttp1(int n, long l, long l2, ProtoHeader protoHeader, ICreditLoginCallback iCreditLoginCallback) {
        CreditLoginHttp1 creditLoginHttp1 = this;
        this.index = 0;
        this.httpResult = -1;
        this.isStop = false;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.networkError = 0;
        this.timeout = n;
        this.yyuid = l2;
        creditLoginHttp1.callback = iCreditLoginCallback;
        creditLoginHttp1.callbackLock = new ReentrantLock();
        this.startTime = l;
        String string = AuthInfo.getCredit(l2);
        if (string == null) {
            string = "";
        }
        CreditLoginHttp1 creditLoginHttp12 = this;
        creditLoginHttp12.creditLoginReq = (CreditLoginReq)CreditLoginReq.newBuilder().setUser(String.valueOf(l2)).setCredit(string).setPrheader(protoHeader).build();
        creditLoginHttp12.url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginByCredit";
        creditLoginHttp12.headers = new HashMap<String, String>();
        creditLoginHttp12.headers.put("Context", "creditLogin");
        creditLoginHttp12.headers.put("AppId", AuthInfo.getAppId());
        creditLoginHttp12.headers.put("Uid", String.valueOf(l2));
        creditLoginHttp12.headers.put("ServiceName", "UdbApp.LoginServer.LoginObj");
        creditLoginHttp12.headers.put("FunctionName", "LoginByCredit");
        creditLoginHttp12.headers.put("ProtoType", "http");
        creditLoginHttp12.headers.put("InstId", "creditLogin");
        creditLoginHttp12.headers.put("ServerId", "creditLogin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute() {
        Class<CreditLoginHttp1> clazz = CreditLoginHttp1.class;
        synchronized (CreditLoginHttp1.class) {
            YYInfo yYInfo;
            YYInfo yYInfo2;
            if (((CreditLoginHttp1)((Object)string)).isStop) {
                ALog.e("CreditLoginHttp stop");
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            if (!NetworkUtil.isNetworkConnected2()) {
                ++((CreditLoginHttp1)((Object)string)).networkError;
                ALog.e("network error " + ((CreditLoginHttp1)((Object)string)).networkError);
            }
            CreditLoginHttp1 creditLoginHttp1 = string;
            ++creditLoginHttp1.index;
            creditLoginHttp1.traceId = UUID.randomUUID().toString();
            creditLoginHttp1.headers.put("TraceId", ((CreditLoginHttp1)((Object)string)).traceId);
            long l = System.currentTimeMillis();
            ALog.i("CreditLogin using http yyuid:" + ((CreditLoginHttp1)((Object)string)).yyuid + ", traceId: " + ((CreditLoginHttp1)((Object)string)).traceId + ", timeout: " + ((CreditLoginHttp1)((Object)string)).timeout + ", url: " + ((CreditLoginHttp1)((Object)string)).url);
            int n = ((CreditLoginHttp1)((Object)string)).timeout;
            Object object = HttpClient.post(creditLoginHttp1.url, ((CreditLoginHttp1)((Object)string)).headers, n, n, ((CreditLoginHttp1)((Object)string)).creditLoginReq.toByteArray(), fun);
            if (object == null) throw new IllegalArgumentException("url, header or data maybe is null");
            long l2 = System.currentTimeMillis() - ((CreditLoginHttp1)((Object)string)).startTime;
            ALog.e("CreditLogin using http total time " + l2);
            if (((HttpClient.HttpResponse)object).needRetry) {
                long l3 = System.currentTimeMillis() - l;
                int n2 = (int)(10000L - l3);
                ALog.e("CreditLogin using http retry " + ((CreditLoginHttp1)((Object)string)).index + ", one time " + n2);
                if (((CreditLoginHttp1)((Object)string)).index < 3 && l2 < 30000L && ((CreditLoginHttp1)((Object)string)).networkError < 2) {
                    if (n2 <= 0) {
                        super.execute();
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                        super.execute();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        ALog.e("CreditLogin using http fail, code " + ((HttpClient.HttpResponse)object).errorCode);
                        ((CreditLoginHttp1)((Object)string)).httpResult = ((HttpClient.HttpResponse)object).errorCode;
                        super.onCreditLoginFailed(l, 4, CodeUtils.makeCode(((HttpClient.HttpResponse)object).httpCode, 1), "network error");
                        return;
                    }
                }
                ALog.e("CreditLogin using http fail, code " + ((HttpClient.HttpResponse)object).errorCode);
                ((CreditLoginHttp1)((Object)string)).httpResult = ((HttpClient.HttpResponse)object).errorCode;
                super.onCreditLoginFailed(l, 4, CodeUtils.makeCode(((HttpClient.HttpResponse)object).httpCode, 1), "network error");
                return;
            }
            try {
                object = CreditLoginRsp.parseFrom(((HttpClient.HttpResponse)object).responseData);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                CreditLoginHttp1 creditLoginHttp12 = string;
                ((CreditLoginHttp1)((Object)string)).httpResult = 6;
                String string = "CreditLogin using http parse InvalidProtocolBufferException, errInfo:" + invalidProtocolBufferException.getMessage();
                ALog.i(string);
                creditLoginHttp12.onCreditLoginFailed(l, 3, CodeUtils.makeCode(((HttpClient.HttpResponse)object).httpCode, 1), string);
                return;
            }
            ALog.i("CreditLogin using http success,uid=" + ((CreditLoginHttp1)((Object)string)).yyuid + ",authSrvCode:" + (Object)((Object)((CreditLoginRsp)object).getErrcode()) + ", authSrvDesc:" + ((CreditLoginRsp)object).getDescription());
            if (((CreditLoginRsp)object).getErrcode() != Errcode.SUCCESS) {
                Object object2 = object;
                ((CreditLoginHttp1)((Object)string)).httpResult = 7;
                int n3 = ((CreditLoginRsp)object2).getErrcodeValue();
                String string = ((CreditLoginRsp)object2).getDescription();
                super.onCreditLoginFailed(l, 4, n3, string);
                return;
            }
            ((CreditLoginHttp1)((Object)string)).httpResult = 0;
            l2 = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && l > 0L) {
                CHidoReport.CReportResponse cReportResponse;
                CHidoReport.CReportResponse cReportResponse2;
                CHidoReport.CReportResponse cReportResponse3 = cReportResponse2 = cReportResponse;
                CHidoReport.CReportResponse cReportResponse4 = cReportResponse2;
                cReportResponse2();
                cReportResponse4.mRtt = l2 - l;
                cReportResponse4.mEventType = "creditLogin/http";
                cReportResponse4.mSucceed = 0;
                cReportResponse4.mErrType = 0;
                cReportResponse4.mErrCode = 0;
                cReportResponse3.mTraceId = ((CreditLoginHttp1)((Object)string)).traceId;
                cReportResponse3.mChannel = "http";
                cReportResponse2.mUserInfo = String.valueOf(((CreditLoginHttp1)((Object)string)).yyuid);
                cReportResponse2.mQuicResult = ((CreditLoginHttp1)((Object)string)).httpResult;
                cReportResponse.mTotalRtt = l2 - ((CreditLoginHttp1)((Object)string)).startTime;
                CHidoReport.getInstance().report2Hido(cReportResponse2);
                CHidoReport.getInstance().report2Metric(cReportResponse2);
            }
            YYInfo yYInfo3 = yYInfo2 = yYInfo;
            Object object3 = object;
            yYInfo2();
            UserInfoUtils.unPack(((CreditLoginRsp)object3).getUserData(), yYInfo2);
            yYInfo3.mTS = ((CreditLoginRsp)object3).getServerTime();
            yYInfo3.mIsNewUser = false;
            yYInfo2.mUrl = ((CreditLoginRsp)object).getUrl();
            yYInfo.extjsstr = ((CreditLoginRsp)object).getExtjsstr();
            AuthInfo.saveAuth(yYInfo.mUid, yYInfo2.mCredit, yYInfo2.mTS * 1000L, yYInfo2.st);
            ThreadManager.executeOnMainThread(new Runnable(){

                @Override
                public void run() {
                    a a2 = this;
                    a2.CreditLoginHttp1.this.onSuccess(0, yYInfo2);
                    AntiHelper.checkAntiCodeHw(a2.yYInfo2.mUid);
                }
            });
            return;
        }
    }

    private void onCreditLoginFailed(long l, final int n, final int n2, final String string) {
        long l2 = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && l > 0L) {
            CHidoReport.CReportResponse cReportResponse;
            CHidoReport.CReportResponse cReportResponse2;
            CHidoReport.CReportResponse cReportResponse3 = cReportResponse2 = cReportResponse;
            CHidoReport.CReportResponse cReportResponse4 = cReportResponse2;
            cReportResponse2();
            cReportResponse4.mRtt = l2 - l;
            cReportResponse4.mEventType = "creditLogin/http";
            cReportResponse4.mSucceed = 2;
            cReportResponse2.mErrType = n + 1;
            cReportResponse2.mErrCode = n2;
            cReportResponse2.mErrDesc = string;
            cReportResponse3.mTraceId = this.traceId;
            cReportResponse3.mChannel = "http";
            cReportResponse2.mUserInfo = String.valueOf(this.yyuid);
            cReportResponse2.mQuicResult = this.httpResult;
            cReportResponse.mTotalRtt = l2 - this.startTime;
            CHidoReport.getInstance().report2Hido(cReportResponse2);
            CHidoReport.getInstance().report2Metric(cReportResponse2);
        }
        ThreadManager.executeOnMainThread(new Runnable(){

            @Override
            public void run() {
                b b2 = this;
                int n3 = b2.n;
                int n22 = b2.n2;
                String string2 = b2.string;
                CreditLoginHttp1.this.onFail(-1, n3, n22, string2);
            }
        });
    }

    @Override
    public void onSuccess(int n, YYInfo yYInfo) {
        CreditLoginHttp1 creditLoginHttp1 = this;
        creditLoginHttp1.callbackLock.lock();
        if (creditLoginHttp1.callback != null) {
            this.callback.onSuccess(n, yYInfo);
        }
        this.callback = null;
        this.callbackLock.unlock();
    }

    @Override
    public void onNext(int n, NextVerify nextVerify) {
        CreditLoginHttp1 creditLoginHttp1 = this;
        creditLoginHttp1.callbackLock.lock();
        if (creditLoginHttp1.callback != null) {
            this.callback.onNext(n, nextVerify);
        }
        this.callback = null;
        this.callbackLock.unlock();
    }

    @Override
    public void onFail(int n, int n2, int n3, String string) {
        CreditLoginHttp1 creditLoginHttp1 = this;
        creditLoginHttp1.callbackLock.lock();
        if (creditLoginHttp1.callback != null) {
            this.callback.onFail(n, n2, n3, string);
        }
        this.callback = null;
        this.callbackLock.unlock();
    }

    @Override
    public void cancel() {
        CreditLoginHttp1 creditLoginHttp1 = this;
        creditLoginHttp1.isStop = true;
        creditLoginHttp1.callback = null;
    }

    @Override
    public void run() {
        this.execute();
    }
}

