/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite;

import android.os.Handler;
import android.os.Looper;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.CHidoReport;
import java.util.ArrayList;
import java.util.List;

public class CallbackProxy<T> {
    public static final int SUCCESS = 1;
    public static final int FAIL = -1;
    protected static final int time = 500;
    protected T callback;
    protected int count;
    private Handler handler;
    private int successCount;
    protected int failCount;
    private volatile boolean isSuccess;
    private volatile boolean isFail;
    private volatile boolean isNext;
    private volatile boolean isReportSuccess;
    private volatile List<CHidoReport.CReportResponse> failList;
    private Object lock;
    private Object faillock;
    private volatile int httpResult;
    private volatile int quicResult;

    public CallbackProxy(T t) {
        CallbackProxy callbackProxy = this;
        this.count = 0;
        this.successCount = 0;
        this.failCount = 0;
        this.isSuccess = false;
        this.isFail = false;
        this.isNext = false;
        this.isReportSuccess = false;
        this.lock = new Object();
        this.faillock = new Object();
        this.httpResult = 0;
        this.quicResult = 0;
        callbackProxy.callback = t;
        callbackProxy.failList = new ArrayList<CHidoReport.CReportResponse>();
    }

    private void report(CHidoReport.CReportResponse cReportResponse) {
        CHidoReport.getInstance().report2Hido(cReportResponse);
        CHidoReport.getInstance().report2Metric(cReportResponse);
    }

    public void increUseCount() {
        CallbackProxy callbackProxy = this;
        ++callbackProxy.count;
        ++callbackProxy.successCount;
        ++callbackProxy.failCount;
        if (callbackProxy.count > 1) {
            this.handler = new Handler(Looper.getMainLooper());
        }
    }

    public void setHttpResult(boolean n) {
        n = n != 0 ? 1 : -1;
        this.httpResult = n;
    }

    public void setQuicResult(boolean n) {
        n = n != 0 ? 1 : -1;
        this.quicResult = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reportSuccess(CHidoReport.CReportResponse cReportResponse) {
        if (this.count == 1) {
            ALog.i("CHidoReport one success");
            cReportResponse.mEventType = cReportResponse.mEventType + "/" + cReportResponse.mChannel;
            this.report(cReportResponse);
            return;
        }
        CallbackProxy callbackProxy = this;
        Object object = callbackProxy.lock;
        synchronized (object) {
            if (callbackProxy.isReportSuccess) {
                return;
            }
            Object object2 = object;
            CallbackProxy callbackProxy2 = this;
            CHidoReport.CReportResponse cReportResponse2 = cReportResponse;
            CHidoReport.CReportResponse cReportResponse3 = cReportResponse2;
            CHidoReport.CReportResponse cReportResponse4 = cReportResponse2;
            ALog.i("CHidoReport multi success");
            this.isReportSuccess = true;
            {
                cReportResponse3.mEventType = cReportResponse.mEventType + "/m" + cReportResponse.mChannel;
                callbackProxy2.report(cReportResponse4);
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFailResponse(CHidoReport.CReportResponse cReportResponse) {
        if (this.count == 1) {
            ALog.i("CHidoReport one fail");
            cReportResponse.mEventType = cReportResponse.mEventType + "/" + cReportResponse.mChannel;
            this.report(cReportResponse);
            return;
        }
        Object object = this.faillock;
        synchronized (object) {
            this.failList.add(cReportResponse);
            return;
        }
    }

    public void reportFail() {
        if (((CallbackProxy)((Object)cReportResponse)).count > 1 && ((CallbackProxy)((Object)cReportResponse)).failList.size() > 0) {
            ALog.i("CHidoReport multi fail");
            int n = ((CallbackProxy)((Object)cReportResponse)).failList.size();
            int n2 = 0;
            for (int i = 1; i < n; ++i) {
                if (((CallbackProxy)((Object)cReportResponse)).failList.get((int)n2).mTotalRtt <= ((CallbackProxy)((Object)cReportResponse)).failList.get((int)i).mTotalRtt) continue;
                n2 = i;
            }
            CallbackProxy callbackProxy = cReportResponse;
            CHidoReport.CReportResponse cReportResponse = callbackProxy.failList.get(n2);
            cReportResponse.mEventType = cReportResponse.mEventType + "/m" + cReportResponse.mChannel;
            callbackProxy.report(cReportResponse);
            callbackProxy.failList.clear();
        }
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean bl) {
        this.isSuccess = bl;
    }

    public boolean isNext() {
        return this.isNext;
    }

    public void setNext(boolean bl) {
        this.isNext = bl;
    }

    public boolean isFail() {
        return this.isFail;
    }

    public void setFail(boolean bl) {
        this.isFail = bl;
    }

    public void postDelay(Runnable runnable, long l) {
        CallbackProxy callbackProxy = callbackProxy.handler;
        if (callbackProxy != null && runnable != null && l >= 0L) {
            callbackProxy.postDelayed(runnable, l);
        } else {
            ALog.i("post delay fail,please check");
        }
    }

    public void clearHandler() {
        CallbackProxy callbackProxy = callbackProxy.handler;
        if (callbackProxy != null) {
            callbackProxy.removeCallbacksAndMessages(null);
        }
    }
}

