/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.utils.HttpClient;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class BaseOkHttp {
    private static final int count = 3;
    private static final int DURATION = 47000;
    private static final int TYPEIP = 1;
    private static final int TYPEURL = 2;
    private static volatile String extra = "";
    protected Call mCall;
    private volatile int index = 0;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    protected String traceId;
    protected String tag;
    private volatile boolean isUseIp = false;
    private volatile boolean isCancel = false;
    private volatile int urlType = 2;
    private volatile String currentUrl = "";
    private int retryCount = -1;
    private int seconds = -1;

    public static String getExtra() {
        return extra;
    }

    public static void clearExtra() {
        extra = "";
    }

    private void canUseIp(boolean bl) {
        this.isUseIp = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void canUseIp(IOException object) {
        this.isUseIp = false;
        if (TextUtils.isEmpty((CharSequence)(object = object != null ? ((Throwable)object).toString() : ""))) {
            return;
        }
        ALog.e("useIp: " + (String)object);
        if (((String)object).length() > 200) {
            object = ((String)object).substring(0, 200);
        }
        if (!(((String)object).contains("java.net.ConnectException") || ((String)object).contains("java.net.UnknownHostException") || ((String)object).contains("java.net.SocketTimeoutException") || ((String)object).contains("javax.net.ssl.SSLHandshakeException"))) {
            if (!((String)object).contains("java.net.NoRouteToHostException")) return;
        }
        this.isUseIp = true;
    }

    public void cancel() {
        BaseOkHttp baseOkHttp = baseOkHttp2;
        extra = "";
        baseOkHttp.isCancel = true;
        baseOkHttp.mHandler.removeCallbacksAndMessages(null);
        BaseOkHttp baseOkHttp2 = baseOkHttp.mCall;
        if (baseOkHttp2 != null) {
            baseOkHttp2.cancel();
        }
    }

    protected String getCurrentUrl() {
        return this.currentUrl;
    }

    protected void setRetryCount(int n) {
        if (n <= 0) {
            return;
        }
        this.retryCount = n;
    }

    protected void setRequestTimeoutSeconds(int n) {
        if (n <= 0) {
            return;
        }
        this.seconds = n;
    }

    public boolean isRequestCancel() {
        return this.isCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeInner(final String string, final Map<String, String> map, final byte[] byArray, final int n) {
        BaseOkHttp baseOkHttp = this;
        extra = "";
        synchronized (baseOkHttp) {
            String string2;
            int n2;
            block8: {
                if (baseOkHttp.isCancel) {
                    BaseOkHttp baseOkHttp2 = this;
                    ALog.e(this.tag + " stop");
                    baseOkHttp2.mHandler.removeCallbacksAndMessages(null);
                    // ** MonitorExit[v1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[this] (shouldn't be in output)
                n2 = n * 3 + 2000;
                if (n2 >= 47000) break block8;
                n2 = 47000;
            }
            ALog.e("timeout: " + n + ", finishTime: " + n2);
            this.traceId = UUID.randomUUID().toString();
            if (this.isUseIp && !TextUtils.isEmpty((CharSequence)(string2 = ServiceUrls.getIpUrl()))) {
                this.urlType = 1;
            } else {
                this.urlType = 2;
                string2 = ServiceUrls.getHttpUrl();
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                extra = "";
                this.onHttpFail(16, "lack of url", 0L);
                return;
            }
            this.currentUrl = string2;
            string2 = string2 + string;
            ALog.i(this.tag + ", traceId: " + this.traceId + ", url: " + string2);
            map.put("TraceId", this.traceId);
            final long l = System.currentTimeMillis();
            this.mCall = HttpClient.getInstance().newCall(HttpClient.makePostRequest(string2, map, byArray, n));
            this.mCall.enqueue(new Callback(){

                public void onFailure(Call object, IOException iOException) {
                    if (object.isCanceled()) {
                        ALog.e("onFailure call is canceled");
                        return;
                    }
                    if (BaseOkHttp.this.urlType == 1) {
                        ServiceUrls.changeIpUrl();
                    }
                    a a2 = this;
                    a2.BaseOkHttp.this.canUseIp(iOException);
                    long l2 = System.currentTimeMillis() - l;
                    a2.BaseOkHttp.this.index++;
                    object = "(" + BaseOkHttp.this.index + "/" + 3 + ")";
                    int n3 = NetworkUtil.getErrorCodeByExc(iOException);
                    ALog.e("onFailure " + (String)object + ", use time " + l2 + ", code: " + n3);
                    if (BaseOkHttp.this.index < 3 && l2 < (long)n2) {
                        BaseOkHttp.this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                a a2 = a2.this;
                                a2.BaseOkHttp.this.executeInner(a2.string, a2.map, a2.byArray, a2.n);
                            }
                        }, 1000L);
                    } else {
                        object = iOException != null ? iOException.getMessage() : "network error";
                        extra = " , timeout: " + n + "ms, realtime: " + n2 + "ms, retry time: " + BaseOkHttp.this.index + ", url: " + BaseOkHttp.this.currentUrl;
                        ALog.e("onFailure message: " + (String)object + extra);
                        BaseOkHttp.this.onHttpFail(n3, (String)object, l2);
                    }
                    if (BaseOkHttp.this.urlType == 2) {
                        ServiceUrls.changeUrl();
                    }
                }

                public void onResponse(Call object, Response object2) {
                    long l2 = System.currentTimeMillis() - l;
                    String string2 = "(" + BaseOkHttp.this.index + "/" + 3 + ")";
                    ALog.e("onResponse " + string2 + ", use time " + l2 + ", code " + object2.code());
                    if (object.isCanceled()) {
                        ALog.e("onResponse call is canceled");
                        return;
                    }
                    extra = " , timeout: " + n + ", realtime: " + n2 + ", retry time: " + BaseOkHttp.this.index + ", url: " + BaseOkHttp.this.currentUrl;
                    if (!object2.isSuccessful()) {
                        a a2 = this;
                        ALog.e("response is not success " + string2 + ", use time " + l2);
                        a2.BaseOkHttp.this.index++;
                        if (a2.BaseOkHttp.this.index < 3 && l2 < (long)n2) {
                            BaseOkHttp.this.mHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    a a2 = a2.this;
                                    a2.BaseOkHttp.this.executeInner(a2.string, a2.map, a2.byArray, a2.n);
                                }
                            }, 1000L);
                        } else {
                            object = object2.message();
                            ALog.e("onResponse fail message: " + (String)object + extra);
                            BaseOkHttp.this.onFail(object2.code(), (String)object, l2);
                        }
                        if (BaseOkHttp.this.urlType == 1) {
                            ServiceUrls.changeIpUrl();
                        }
                        if (BaseOkHttp.this.urlType == 2) {
                            ServiceUrls.changeUrl();
                        }
                    } else {
                        Response response = object2;
                        int n3 = response.code();
                        ALog.e("response is success");
                        object2 = response.body().bytes();
                        BaseOkHttp.this.onSuccess((Call)object, (byte[])object2, n3, l2);
                    }
                }
            });
            return;
        }
    }

    protected String compose(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "https";
        }
        if (this.urlType == 1) {
            return string + "/ip";
        }
        if (this.currentUrl.startsWith("https://")) {
            return string + "/https";
        }
        if (this.currentUrl.startsWith("http://")) {
            return string + "/http";
        }
        return string + "/https";
    }

    public abstract void onSuccess(Call var1, byte[] var2, int var3, long var4);

    public abstract void onFail(int var1, String var2, long var3);

    public abstract void onHttpFail(int var1, String var2, long var3);
}

