/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.loginlite;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.AuthCore;
import com.yy.platform.loginlite.ICreditLoginCallback;
import com.yy.platform.loginlite.NextVerify;
import com.yy.platform.loginlite.YYInfo;
import com.yy.platform.loginlite.proto.ProtoHeader;
import com.yy.platform.loginlite.utils.CodeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class AuthInfo {
    private static volatile AuthInfo sInstance;
    private static ProtoHeader sHeader;
    private static ProtoHeader.Builder sHeaderBuilder;
    protected static Context sContext;
    public static final String Key_SubAppid = "subappid";
    private static final String Key_DeviceType = "devicetype";
    public static final String Key_DEVICEID = "deviceid";
    public static final String Key_HDID = "hdid";
    public static final String Key_PCID = "pcid";
    private static String sAntiBizName = "";
    private static String sAppId;
    private static String sRegion = "";
    private static SharedPreferences sAuthPref;
    private static String hdid = "";
    private static LoginAuth sAuthed;
    private static Map<Long, LoginAuth> sAuthInfo;
    private static String UIDS_KEY = "UIDS";
    private static String CREDIT_KEY_SUFFIX = "_CREDIT";
    private static String TS_KEY_SUFFIX = "_TS";
    private static String QUIC_CONFIG_PREFIX = "QUIC_";
    private static String LOCAL_PREFIX = "_local";
    private static String DIFF_PREFIX = "_diff";
    private static String STOKEN_PREFIX = "_st";
    private static String PRE_LOCAL_PREFIX = "_prev_local";
    private static final long DAY = 86400000L;
    private static String sRegionSet;
    private static int sABTest = 0;
    private static Map<Long, Boolean> sEnableQuic;

    private AuthInfo() {
    }

    public static synchronized void setRegionSet(String string) {
        sRegionSet = string;
    }

    public static synchronized String getRegionSet() {
        return sRegionSet;
    }

    public static synchronized String getRegionSetKey() {
        return "setselector";
    }

    public static synchronized void setABTest(int n) {
        sABTest = n;
    }

    public static synchronized int getABTest() {
        return sABTest;
    }

    public static synchronized AuthInfo init(Context object, String iterator, String string6, String string2, String string3, String string4, String string5, Map<String, String> map) {
        if (sInstance == null) {
            sInstance = new AuthInfo();
            sContext = object;
            sAuthPref = sContext.getSharedPreferences((String)((Object)iterator) + "loginlite", 0);
            sAppId = iterator;
            sRegion = string3;
            if (string5 == null) {
                string5 = "";
            }
            hdid = string5;
            if (string4 == null) {
                string4 = "";
            }
            sAntiBizName = string4;
            AuthInfo.loadAuth();
            object = AuthInfo.getAppVer();
            iterator = ProtoHeader.newBuilder().setInfVer("1").setAppId((String)((Object)iterator)).setAppVer((String)object).setSys("android").setSysVer("android" + Build.VERSION.RELEASE).setDeviceId(hdid).setRegion(string3).setImei(hdid).setMac("");
            string3 = Key_SubAppid;
            if (string6 == null) {
                string6 = "";
            }
            iterator = ((ProtoHeader.Builder)((Object)iterator)).putExtmap(string3, string6);
            string6 = Key_DeviceType;
            if (string2 == null) {
                string2 = "";
            }
            sHeaderBuilder = ((ProtoHeader.Builder)((Object)iterator)).putExtmap(string6, string2).setSimNum("");
            if (map != null && map.size() > 0) {
                for (String string6 : map.keySet()) {
                    string2 = map.get(string6);
                    if (string2 == null) continue;
                    sHeaderBuilder.putExtmap(string6, string2);
                }
            }
            sHeader = (ProtoHeader)sHeaderBuilder.build();
            ALog.i("preHeader,appId:" + sHeader.getAppId() + ",region:" + sHeader.getRegion() + ", appVer: " + (String)object);
        }
        return sInstance;
    }

    public static synchronized void setExtMap(Map<String, String> map) {
        if (sHeaderBuilder != null && map != null && map.size() > 0) {
            for (String string : map.keySet()) {
                sHeaderBuilder.putExtmap(string, map.get(string));
            }
            sHeader = (ProtoHeader)sHeaderBuilder.build();
        }
    }

    public static String getAppId() {
        return sAppId;
    }

    public static String getRegion() {
        return sRegion;
    }

    public static String getAntiBizName() {
        return sAntiBizName;
    }

    public static ProtoHeader getHeader() {
        return sHeader;
    }

    public static ProtoHeader.Builder getHeaderBuilder() {
        return sHeaderBuilder;
    }

    public static Context getAppContext() {
        return sContext;
    }

    public static String getAppVer() {
        Object object;
        block5: {
            block4: {
                try {
                    object = sContext.getPackageManager().getPackageInfo(sContext.getPackageName(), 0);
                }
                catch (Throwable throwable) {
                    ALog.i("getAppVer ex:" + throwable.getMessage());
                    return "";
                }
                if (object.versionName != null) break block4;
                object = "";
                break block5;
            }
            object = object.versionName;
        }
        return object;
    }

    public static String getSdkVersion() {
        return "2.7.21.20";
    }

    private static synchronized void loadAuth() {
        sAuthInfo = new HashMap<Long, LoginAuth>();
        Object object = sAuthPref.getStringSet(UIDS_KEY, null);
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                ALog.i("one user:" + string);
                sAuthed = new LoginAuth();
                AuthInfo.sAuthed.mUid = CodeUtils.parseLongCode(string, -1);
                AuthInfo.sAuthed.mTS = sAuthPref.getLong(string + TS_KEY_SUFFIX, 0L);
                AuthInfo.sAuthed.mCredit = sAuthPref.getString(string + CREDIT_KEY_SUFFIX, "");
                AuthInfo.sAuthed.mLocal = sAuthPref.getLong(string + LOCAL_PREFIX, 0L);
                AuthInfo.sAuthed.mPrevLocal = sAuthPref.getLong(string + PRE_LOCAL_PREFIX, 0L);
                AuthInfo.sAuthed.mDiff = sAuthPref.getLong(string + DIFF_PREFIX, 0L);
                AuthInfo.sAuthed.st = sAuthPref.getString(string + STOKEN_PREFIX, "");
                sAuthInfo.put(AuthInfo.sAuthed.mUid, sAuthed);
            }
        } else {
            ALog.i("no any user");
        }
    }

    protected static synchronized String getCredit(long l) {
        Object object = sAuthed;
        if (object != null && ((LoginAuth)object).mUid != l) {
            sAuthed = null;
        }
        if ((object = sAuthInfo.get(l)) == null) {
            long l2;
            block10: {
                object = sContext.getSharedPreferences(sAppId + "pbmars", 0);
                l2 = CodeUtils.parseLongCode(object.getString("LAST_YYUID", ""), -1);
                if (l != l2) break block10;
                LoginAuth loginAuth = object;
                LoginAuth loginAuth2 = loginAuth;
                object = loginAuth.getString("LAST_CREDIT", "");
                String string = loginAuth2.getString("LAST_CREATETS", "");
                "".equals(string);
                Object object2 = object;
                long l3 = CodeUtils.parseLongCode(string, -1);
                sAuthed = new LoginAuth();
                AuthInfo.sAuthed.mUid = l;
                AuthInfo.sAuthed.mTS = l3;
                AuthInfo.sAuthed.mCredit = object;
                sAuthInfo.put(AuthInfo.sAuthed.mUid, sAuthed);
                try {
                    ALog.i("last auth info for uid/credit len/ts" + l + "," + ((String)object).length() + "," + string);
                    return object2;
                }
                catch (NumberFormatException numberFormatException) {
                    l2 = 0L;
                }
            }
            ALog.i("no auth info for get uid/last uid:" + l + "," + l2);
            return "";
        }
        return ((LoginAuth)object).mCredit;
    }

    protected static synchronized void saveAuth(long l, String charSequence, long l2, String charSequence2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        StringBuilder stringBuilder4;
        StringBuilder stringBuilder5;
        StringBuilder stringBuilder6;
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (sAuthInfo.containsKey(l)) {
            l4 = AuthInfo.sAuthInfo.get((Object)Long.valueOf((long)l)).mLocal;
        }
        LoginAuth loginAuth = sAuthed = new LoginAuth();
        loginAuth.mUid = l;
        loginAuth.mCredit = charSequence;
        loginAuth.mTS = l2;
        loginAuth.mLocal = l3;
        loginAuth.mPrevLocal = l4;
        AuthInfo.sAuthed.mDiff = l2 - l3;
        if (charSequence2 == null) {
            charSequence2 = "";
        }
        loginAuth.st = charSequence2;
        ALog.i("login success ts:" + l2);
        ALog.i("login success prev:" + l4 + ",current: " + l3 + ",diff: " + AuthInfo.sAuthed.mDiff);
        sAuthInfo.put(l, sAuthed);
        if (charSequence == null || charSequence.isEmpty()) {
            ALog.i("warning for uid:" + l + ",credit is empty");
            charSequence = "";
        }
        charSequence2 = sAuthPref.edit();
        Set set = sAuthPref.getStringSet(UIDS_KEY, null);
        if (set == null) {
            HashSet hashSet;
            set = hashSet;
            hashSet = new HashSet();
        }
        String string = charSequence2;
        set.add(String.valueOf(l));
        string.putStringSet(UIDS_KEY, set);
        charSequence2 = stringBuilder6;
        ((StringBuilder)charSequence2)();
        string.putString(stringBuilder6.append(l).append(CREDIT_KEY_SUFFIX).toString(), charSequence);
        charSequence = stringBuilder5;
        ((StringBuilder)charSequence)();
        string.putLong(stringBuilder5.append(l).append(TS_KEY_SUFFIX).toString(), l2);
        charSequence = stringBuilder4;
        ((StringBuilder)charSequence)();
        string.putLong(stringBuilder4.append(l).append(LOCAL_PREFIX).toString(), l3);
        charSequence = stringBuilder3;
        ((StringBuilder)charSequence)();
        string.putLong(stringBuilder3.append(l).append(PRE_LOCAL_PREFIX).toString(), AuthInfo.sAuthed.mPrevLocal);
        charSequence = stringBuilder2;
        ((StringBuilder)charSequence)();
        string.putLong(stringBuilder2.append(l).append(DIFF_PREFIX).toString(), AuthInfo.sAuthed.mDiff);
        charSequence = stringBuilder;
        ((StringBuilder)charSequence)();
        string.putString(stringBuilder.append(l).append(STOKEN_PREFIX).toString(), AuthInfo.sAuthed.st);
        if (!string.commit()) {
            ALog.i("fail to save for uid:" + l);
        } else {
            ALog.i("success to save for uid:" + l);
        }
    }

    protected static synchronized byte[] getOtp(String charSequence, long l) {
        LoginAuth loginAuth = sAuthed;
        if (loginAuth != null) {
            String string;
            if (loginAuth.mUid != l) {
                ALog.i("current uid: " + AuthInfo.sAuthed.mUid + ",uid:" + l);
                loginAuth = sAuthInfo.get(l);
                if (loginAuth == null) {
                    ALog.i("no authed info for dest app:" + (String)charSequence + ", uid: " + l);
                    return "".getBytes();
                }
                sAuthed = loginAuth;
            }
            if ((string = AuthInfo.sAuthed.mCredit) != null && !string.isEmpty()) {
                if (charSequence == null || ((String)charSequence).isEmpty()) {
                    charSequence = sAppId;
                }
                long l2 = System.currentTimeMillis();
                long l3 = AuthInfo.sAuthed.mLocal - l2;
                StringBuilder stringBuilder = new StringBuilder().append("getOtp, now: ").append(l2).append(" last login: ").append(AuthInfo.sAuthed.mLocal).append(" need refresh: ");
                boolean bl = Math.abs(l3) >= 86400000L;
                ALog.i(stringBuilder.append(bl).toString());
                AuthInfo.sAuthed.mLocal = l2;
                if (AuthInfo.sAuthed.mPrevLocal > 0L && Math.abs(l3) >= 86400000L) {
                    ALog.i("\u5237\u65b0\u51ed\u636e");
                    LoginAuth loginAuth2 = sAuthed;
                    AuthCore.getInstance().creditLogin(loginAuth2.mUid, loginAuth2.st, new ICreditLoginCallback(){

                        @Override
                        public void onSuccess(int n, YYInfo yYInfo) {
                        }

                        @Override
                        public void onNext(int n, NextVerify nextVerify) {
                        }

                        @Override
                        public void onFail(int n, int n2, int n3, String string) {
                        }
                    });
                }
                Object object = sAuthed;
                long l4 = (l2 + ((LoginAuth)object).mDiff) / 1000L;
                object = AuthInfo.getRandomString(((LoginAuth)object).mCredit.length() / 20);
                LoginAuth loginAuth3 = sAuthed;
                byte[] byArray = AuthCore.getOtp(loginAuth3.mUid, l4, loginAuth3.mCredit.getBytes(), sAppId.getBytes(), ((String)charSequence).getBytes(), hdid.getBytes(), ((String)object).getBytes());
                object = byArray;
                charSequence = new StringBuilder().append("for dest app:").append((String)charSequence).append(" otp size:");
                int n = byArray == null ? 0 : ((Object)object).length;
                ALog.i(((StringBuilder)charSequence).append(n).toString());
                return object;
            }
            ALog.i("no credit for dest app:" + (String)charSequence + ",uid:" + AuthInfo.sAuthed.mUid);
            return "".getBytes();
        }
        ALog.i("no authed info for dest app:" + (String)charSequence + ", uid: " + l);
        return "".getBytes();
    }

    protected static synchronized byte[] getServiceOtp(long l) {
        return AuthInfo.getOtp("signap", l);
    }

    protected static synchronized void logout(boolean bl) {
        if (sAuthed == null) {
            ALog.i("no authed info");
            return;
        }
        if (!bl) {
            ALog.i("disable auto login next time for uid:" + AuthInfo.sAuthed.mUid);
            SharedPreferences.Editor editor = sAuthPref.edit();
            Set set = sAuthPref.getStringSet(UIDS_KEY, null);
            if (set == null) {
                HashSet hashSet;
                set = hashSet;
                hashSet = new HashSet();
            }
            SharedPreferences.Editor editor2 = editor;
            set.remove(String.valueOf(AuthInfo.sAuthed.mUid));
            editor2.putStringSet(UIDS_KEY, set);
            editor2.remove(AuthInfo.sAuthed.mUid + CREDIT_KEY_SUFFIX);
            editor2.remove(AuthInfo.sAuthed.mUid + TS_KEY_SUFFIX);
            if (!editor2.commit()) {
                ALog.i("fail to clear for uid:" + AuthInfo.sAuthed.mUid);
            } else {
                ALog.i("success to clear for uid:" + AuthInfo.sAuthed.mUid);
            }
            sAuthInfo.remove(AuthInfo.sAuthed.mUid);
        }
        sAuthed = null;
    }

    protected static String getRandomString(int n) {
        Random random;
        char[] cArray = new char[n];
        Random random2 = random;
        random = new Random();
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(random2.nextInt(9) + 97);
        }
        return new String(cArray);
    }

    public static synchronized boolean isEnableQuic(long l) {
        if (sABTest == 1) {
            boolean bl = AuthInfo.getQuicConfig(l);
            StringBuilder stringBuilder = new StringBuilder().append("is enable quic for uid:").append(l).append("->");
            String string = bl ? "true" : "false";
            ALog.i(stringBuilder.append(string).toString());
            return bl;
        }
        return false;
    }

    public static synchronized boolean getQuicConfig(long l) {
        Map<Long, Boolean> map = sEnableQuic;
        if (map == null) {
            boolean bl = sAuthPref.getBoolean(QUIC_CONFIG_PREFIX + l, true);
            sEnableQuic = new HashMap<Long, Boolean>();
            sEnableQuic.put(l, bl);
            return bl;
        }
        if (map.containsKey(l)) {
            return sEnableQuic.get(l);
        }
        return true;
    }

    public static synchronized void setQuicConfig(long l, boolean bl) {
        if (sEnableQuic == null) {
            sEnableQuic = new HashMap<Long, Boolean>();
            sEnableQuic.put(l, bl);
        }
        SharedPreferences.Editor editor = sAuthPref.edit();
        editor.putBoolean(QUIC_CONFIG_PREFIX + l, bl);
        if (!editor.commit()) {
            ALog.i("fail to save quic config for uid:" + l + ",enabled:" + bl);
        } else {
            ALog.i("success to save quic config for uid:" + l + ",credit:" + bl);
        }
    }

    protected static class LoginAuth {
        protected long mUid = 0L;
        protected String mCredit = "";
        protected long mTS = 0L;
        protected long mLocal = 0L;
        protected long mPrevLocal = 0L;
        protected long mDiff = 0L;
        protected String st = "";

        protected LoginAuth() {
        }
    }
}

