package com.yy.platform.loginlite.utils;

import java.security.MessageDigest;

/**
 * Created by chenkaicai on 2018/7/16.
 */

public class YYLoginliteUtils {
    /**
     * 对密码进行Sha1加密
     *
     * @param password 原密码
     * @return 返回加密后的字符串，如果失败则返回null
     */
    public static String getPasswdSha1(String password) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance("sha-1");
            byte[] bytes = password.getBytes();
            int byteCount = password.getBytes().length;
            if (byteCount > 0) {
                digester.update(bytes, 0, byteCount);
            }
            byte[] digest = digester.digest();

            String hexString = "0123456789abcdef";
            byte[] hexChars = hexString.getBytes();

            byte[] digestChar = new byte[40];
            for (int i = 0; i < 20; ++i) {
                digestChar[2 * i] = hexChars[(digest[i] & 0xF0) >> 4];
                digestChar[2 * i + 1] = hexChars[digest[i] & 0x0F];
            }

            return new String(digestChar);

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
