package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.YYInfo;
import com.yy.platform.loginlite.proto.ProtoUserData;

import org.json.JSONObject;

import java.util.Map;

public class UserInfoUtils {

    public static void unPack(ProtoUserData userData, YYInfo info) {
        if (userData == null || info == null) {
            return;
        }
        info.mUid = userData.getUid();
        info.mCredit = userData.getCredit();
        info.mUno = userData.getUno();

        info.signapotp = userData.getSignapotp();
        info.accesstoken = userData.getAccesstoken();
        // 格式国家-大区
        String regRegion = userData.getRegRegion();
        info.regRegion = regRegion;
        info.mobilemask = userData.getMobilemask();
        Map<String, String> extmap = userData.getExtmapMap();
        info.extmap = extmap;

        ALog.e("yy info: " + info.extmap);

        if (extmap != null) {
            info.localHost = extmap.get("local_host");
            info.registerHost = extmap.get("register_host");
            info.registerIdc = extmap.get("register_idc");
            info.cproxyHost = extmap.get("cproxy_host");
            info.gameHost = extmap.get("game_host");
            info.turnoverHost = extmap.get("turnover_host");
            info.lcid = extmap.get("lcid");
            info.st = extmap.get("sT");
            info.session = extmap.get("sSession");

            String value = extmap.get("lifecycle");
            try {
                if (!TextUtils.isEmpty(value)) {
                    info.lifecycle = Integer.parseInt(value);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            String authed = extmap.get("auth_app");
            if (!TextUtils.isEmpty(authed)) {
                try {
                    info.isAuthed = Boolean.parseBoolean(authed);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        try {
            JSONObject jsonObject = new JSONObject(regRegion);
            String data = jsonObject.optString("region");
            ALog.e("-------- parse YYInfo notice, region(region) = " + data + " ---------");
            if (TextUtils.isEmpty(data)) {
                return;
            }
            String[] values = data.split("-");
            if (values == null || values.length != 2) {
                return;
            }
            // 正常是realCountry-registerCountry
            info.registerCountry = values[1] == null ? "" : values[1];
            info.realCountry = values[0] == null ? "" : values[0];

            ALog.e("-------- parse YYInfo notice, region(region) = " + data +
                    ", realCountry = " + info.realCountry + ", registerCountry = " +
                    info.registerCountry);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
