package com.yy.platform.loginlite.utils;

import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;

import android.os.Looper;

import com.yy.platform.loginlite.ALog;

public final class ThreadManager {

    // UI线程
    private static Handler mManinHandler;
    private static final int NUM = 2;

    /**
     * AsyncTask的默认线程池Executor. 负责长时间的任务(网络访问) 默认3个线程
     */
    protected volatile static Executor NETWORK_EXECUTOR;

    private static Executor initNetworkExecutor() {
        Executor result = null;
        // 3.0以上
        if (Build.VERSION.SDK_INT >= 11) {
            //result = AsyncTask.THREAD_POOL_EXECUTOR;
            result = new ThreadPoolExecutor(NUM, NUM, 0, TimeUnit.SECONDS,
                    new LinkedBlockingQueue<Runnable>());
        } else {
            // 3.0以下, 反射获取
            Executor tmp = null;
            try {
                Field field = AsyncTask.class.getDeclaredField("sExecutor");
                field.setAccessible(true);
                tmp = (Executor) field.get(null);
            } catch (Exception e) {
                tmp = new ThreadPoolExecutor(NUM, NUM, 0, TimeUnit.SECONDS,
                        new LinkedBlockingQueue<Runnable>());
            }
            result = tmp;
        }

        if (result instanceof ThreadPoolExecutor) {
            // core size减少为1个
            ((ThreadPoolExecutor) result).setCorePoolSize(NUM);
        }

        return result;
    }

    public static void init() {
        if (NETWORK_EXECUTOR == null) {
            synchronized (ThreadManager.class) {
                if (NETWORK_EXECUTOR == null) {
                    NETWORK_EXECUTOR = initNetworkExecutor();
                }
            }
        }
    }

    /**
     * 取得UI线程Handler
     *
     * @return
     */
    public static Handler getMainHandler() {
        if (mManinHandler == null) {
            synchronized (ThreadManager.class) {
                if (mManinHandler == null) {
                    mManinHandler = new Handler(Looper.getMainLooper());
                }
            }
        }
        return mManinHandler;
    }

    public static void executeOnMainThread(Runnable run) {
        if (run == null) {
            return;
        }
        getMainHandler().postAtFrontOfQueue(run);
//        getMainHandler().post(run);
    }

    /**
     * 在网络线程上执行异步操作. 该线程池负责网络请求等操作 长时间的执行(如网络请求使用此方法执行) 当然也可以执行其他 线程和AsyncTask公用
     *
     * @param run
     */
    public synchronized static void executeOnNetWorkThread(Runnable run) {
        if (run == null) {
            return;
        }
        try {
            if (NETWORK_EXECUTOR == null) {
                NETWORK_EXECUTOR = initNetworkExecutor();
            }
            NETWORK_EXECUTOR.execute(run);
        } catch (RejectedExecutionException e) {
            ALog.i("ex:" + e.getLocalizedMessage());
        }
    }

    /**
     * 在副线程执行. <br>
     * 可以执行本地文件读写等比较快但不能在ui线程执行的操作.<br>
     * <b>此线程禁止进行网络操作.如果需要进行网络操作. 请使用NETWORK_EXECUTOR</b>
     *
     * @return
     */
    public static void executeOnSubThread(Runnable run) {
        if (run == null) {
            return;
        }
        new Thread(run).start();
    }

    public static void executeOnSubThread(final Runnable run, long delay) {
        if (run == null) {
            return;
        }
        getMainHandler().postDelayed(new Runnable() {
            @Override
            public void run() {
                new Thread(run).start();
            }
        }, delay);
    }
}
