package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.ThirdInfo;

import org.json.JSONException;
import org.json.JSONObject;

public class ThirdInfoUtils {

    public static void unPack(JSONObject jsonData, ThirdInfo info) throws JSONException {
        if (jsonData == null || info == null) {
            return;
        }
        info.mUid = CodeUtils.parseLongCode(jsonData.optString("uid"), CodeUtils.UIDDEFAULT);
        info.mIsNewUser = jsonData.optBoolean("newUser");
        info.mCredit = jsonData.optString("loginToken");
        info.mChannel = jsonData.optString("channel");
        //单位s
        info.mTS = jsonData.optInt("serverTime");
        info.mThirdInfo = jsonData.optString("thirdUser");

        info.mBizParam = jsonData.optString("busiParam");
        info.mExt = jsonData.optString("ext", "");

        ALog.e("third info: " + info.mExt);

        JSONObject extJson = new JSONObject(info.mExt);
        info.localHost = extJson.optString("local_host");
        info.registerHost = extJson.optString("register_host");
        info.registerIdc = extJson.optString("register_idc");
        info.cproxyHost = extJson.optString("cproxy_host");
        info.gameHost = extJson.optString("game_host");
        info.turnoverHost = extJson.optString("turnover_host");
        info.lcid = extJson.optString("lcid");
        info.st = extJson.optString("sT");
        info.session = extJson.optString("sSession");
        String value = extJson.optString("lifecycle");
        try {
            if (!TextUtils.isEmpty(value)) {
                info.lifecycle = Integer.parseInt(value);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        String authed = extJson.optString("auth_app", "");
        if (!TextUtils.isEmpty(authed)) {
            try {
                info.isAuthed = Boolean.parseBoolean(authed);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (!pickRight(extJson, info)) {
            try {
                String data = extJson.optString("region");
                ALog.e("-------- parse thirdInfo notice, region(region) = " + data + "-------");
                if (TextUtils.isEmpty(data)) {
                    return;
                }
                String[] values = data.split("-");
                if (values == null || values.length != 2) {
                    return;
                }
                // 反过来取值，正常应该是realCountry-registerCountry
                info.registerCountry = values[0] == null ? "" : values[0];
                info.realCountry = values[1] == null ? "" : values[1];
                ALog.e("-------- parse thirdInfo notice, region(region) = " + data +
                        ", realCountry = " + info.realCountry + ", registerCountry = " +
                        info.registerCountry);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean pickRight(JSONObject extJson, ThirdInfo info) {
        if (extJson == null || info == null) {
            return false;
        }
        try {
            String right = extJson.optString("region_right");
            ALog.e("-------- parse thirdInfo notice, region(region_right) = " + right + "-------");
            if (TextUtils.isEmpty(right)) {
                return false;
            }
            String[] values = right.split("-");
            if (values == null || values.length != 2) {
                return false;
            }
            info.realCountry = values[0] == null ? "" : values[0];
            info.registerCountry = values[1] == null ? "" : values[1];
            ALog.e("-------- parse thirdInfo notice, region(region_right) = " + right +
                    ", realCountry = " + info.realCountry + ", registerCountry = " +
                    info.registerCountry);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}
