package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.platform.loginlite.ALog;
import com.yy.platform.outudb.BuildConfig;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ServiceUrls {

    private static final String DEFAULT_HTTP_URL = "https://lgglobalb.yy.com";
    private static final String TEST_URL = "http://118.191.192.167:8090";
    //    private static final String QUIT_URL = "https://lgglobal.yy.com";
    public static final String HTTP_SEP = "/";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final int HTTP_CONNECT_TIMEOUT = 5 * 1000;
    private static String currentHttpUrl = DEFAULT_HTTP_URL;
    private static String currentQuicUrl = "";
    private static String testHttpUrl = "";
    private volatile static int index = 0;
    private volatile static int ipIndex = 0;
    private volatile static int testIndex = 0;

    private static volatile boolean isTest = false;
    private static volatile boolean useDefault = true;
    private static volatile List<String> bizUrls;
    private static volatile List<String> testUrls = new LinkedList<>();
    private static volatile List<String> httpIps;

    /**
     * 设置测试环境域名
     *
     * @param url  http请求的域名
     * @param quic quic请求的域名
     */
    public static void setTestUrl(String url, String quic) {
        if (!TextUtils.isEmpty(url)) {
            isTest = true;
            testHttpUrl = url;
            if (!testUrls.contains(url)) {
                testUrls.add(url);
            }
            ALog.i("setTestUrl " + testUrls);
        }
        if (!TextUtils.isEmpty(quic)) {
            currentQuicUrl = quic;
        }
    }

    public static List<String> getBizRequestUrls() {
        return bizUrls;
    }

    /**
     * 设置登录sdk的https请求的url，例如：https://lgglobalb.oldparty.com
     *
     * @param httpsUrls
     * @param isUseDefaultHost 是否使用sdk自带的默认域名
     */
    public synchronized static void setBizRequestUrls(List<String> httpsUrls,
                                                      boolean isUseDefaultHost) {
        index = 0;
        testIndex = 0;
        if (isRelease()) {
            isTest = false;
        }
        useDefault = isUseDefaultHost;
        bizUrls = httpsUrls;
        // 测试url
        if (httpsUrls == null || httpsUrls.size() == 0) {
            testUrls.clear();
        } else {
            testUrls.clear();
            for (String url : httpsUrls) {
                if (url != null && url.trim().length() > 0) {
                    testUrls.add(url);
                }
            }
        }
        if (isTest && !testUrls.contains(testHttpUrl)) {
            testUrls.add(testHttpUrl);
        }
        ALog.i("setBizRequestUrls " + testUrls);
    }


    private static boolean isRelease() {
        final String version = BuildConfig.BUILD_VERSION;
        if (version.indexOf("SNAPSHOT") != -1) {
            return false;
        }
        return true;
    }

    /**
     * 设置http请求的ip直连url，例如：http://127.0.0.1:8080
     *
     * @param ips
     */
    public synchronized static void setRequestHttpIps(List<String> ips) {
        httpIps = ips;
    }

    public static List<String> getRequestHttpIps() {
        return httpIps;
    }

    public synchronized static String getIpUrl() {
        if (httpIps == null || httpIps.size() == 0) {
            return "";
        }
        int size = httpIps.size();
        if (ipIndex >= size) {
            ipIndex = 0;
        }
        String ip = httpIps.get(ipIndex);
        if (TextUtils.isEmpty(ip)) {
            return "";
        }
        ALog.e("ip url: " + ip + ", index: " + ipIndex);
        return ip + HTTP_SEP;
    }

    public synchronized static void changeIpUrl() {
        if (httpIps == null || httpIps.size() == 0) {
            return;
        }
        int size = httpIps.size();
        ipIndex = (ipIndex + 1) % size;
    }

    public static void changeUrl() {
        if (isTest) {
            synchronized (ServiceUrls.class) {
                int size = testUrls.size();
                testIndex = (testIndex + 1) % size;
                ALog.e("test changeUrl index: " + testIndex + ", size: " + size);
            }
            return;
        }
        synchronized (ServiceUrls.class) {
            if (bizUrls == null || bizUrls.size() == 0) {
                return;
            }
            int size = bizUrls.size();
            if (useDefault) {
                size = size + 1;
            }
            index = (index + 1) % size;
            ALog.e("changeUrl index: " + index + ", size: " + size);
        }
    }

    public static String getCurrentRequestUrl() {
        return getHttpUrl();
    }

    public static String getHttpUrl() {
        String fUrl;
        if (isTest) {
            synchronized (ServiceUrls.class) {
                int size = testUrls.size();
                if (testIndex >= size) {
                    testIndex = 0;
                }
                fUrl = testUrls.get(testIndex);
                ALog.e("isTest url: " + fUrl);
            }
        } else {
            synchronized (ServiceUrls.class) {
                if (bizUrls == null || bizUrls.size() == 0) {
                    if (useDefault) {
                        return DEFAULT_HTTP_URL + HTTP_SEP;
                    } else {
                        return "";
                    }
                }
                if (useDefault) {
                    int size = bizUrls.size();
                    if (index == size) {
                        fUrl = DEFAULT_HTTP_URL;
                    } else {
                        fUrl = bizUrls.get(index);
                    }
                } else {
                    fUrl = bizUrls.get(index);
                }

                ALog.e("normal url: " + fUrl + ", index: " + index);
            }
        }
        return fUrl + HTTP_SEP;
    }

    public static String getQuitUrl() {
        return currentQuicUrl + HTTP_SEP;
    }

    public static ArrayList<String> getHost() {
        ArrayList<String> list = new ArrayList<>(1);
        if (useDefault) {
            list.add("lgglobalb.yy.com");
        }
        return list;
    }
}
