package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.platform.loginlite.ALog;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import okhttp3.Dns;

/**
 * Created by Administrator on 2017/5/9.
 */

public class OkHttpDns implements Dns {
    private static OkHttpDns instance = null;
    private static final String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";

    private OkHttpDns() {
    }

    public static OkHttpDns getInstance() {
        if (instance == null) {
            instance = new OkHttpDns();
        }
        return instance;
    }

    @Override
    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        if (TextUtils.isEmpty(hostname)) {
            throw new UnknownHostException("hostname is empty");
        }
        try {
            if (isIp(hostname)) {
                ALog.e(hostname + " is ip");
                InetAddress value = InetAddress.getByName(hostname);
                if (value != null) {
                    return Arrays.asList(value);
                }
            }
            ALog.e(hostname + " is not ip, is url");
            List<String> info = GslbDns.inst().getIps(hostname);
            if (info != null && info.size() > 0) {
                List<InetAddress> inetAddresses = new ArrayList<>();
                for (int i = 0; i < info.size(); i++) {
                    String ip = info.get(i);
                    if (TextUtils.isEmpty(ip)) {
                        continue;
                    }
                    InetAddress addr = InetAddress.getByName(ip);
                    if (addr != null) {
                        inetAddresses.add(addr);
                    }
                }
                if (inetAddresses.size() > 0) {
                    return inetAddresses;
                }
            }
            return Dns.SYSTEM.lookup(hostname);
        } catch (IllegalArgumentException e) {
            // We can't throw SocketException. We aren't meant to see bad addresses, so seeing one
            // really does imply an internal error.

            // Hack. See https://github.com/square/okhttp/issues/3345
            throw new UnknownHostException(e.getMessage());
        } catch (Exception e) {
            throw new UnknownHostException(e.getMessage());
        }
    }

    private boolean isIp(String hostname) {
        return hostname.matches(ip);
    }
}