package com.yy.platform.loginlite.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.AuthInfo;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class NetworkUtil {

    public static boolean isNetworkConnected() {
        if (AuthInfo.getAppContext() == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager) AuthInfo.getAppContext()
                .getSystemService(Context.CONNECTIVITY_SERVICE);

        if (connectivityManager == null) {
            return false;
        }

        NetworkInfo mNetworkInfo = connectivityManager.getActiveNetworkInfo();
        if (mNetworkInfo == null) {
            return false;
        }

        if (mNetworkInfo.isConnected()) {
            return true;
        }
        if (mNetworkInfo.isAvailable() && mNetworkInfo.isConnectedOrConnecting()) {
            return true;
        }
        return false;
    }

    public static boolean isNetworkConnected2() {
        return isNetworkConnected2(AuthInfo.getAppContext());
    }

    public static boolean isNetworkConnected2(Context context) {
        try {
            ConnectivityManager connectivityManager =
                    (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (connectivityManager != null) {
//NetworkInfo [] networkInfos = connectivityManager.getAllNetworkInfo();
//获取网络的连接情况，断网时会是一个null
                NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                //以下是正确的判断有无网络数据链接的方法，isAvailable仅表示WIFI开关
                if (activeNetInfo != null && (activeNetInfo.getState() != null)) {
                    NetworkInfo.State state = activeNetInfo.getState();
                    ALog.i("isNetworkConnected2 Network value is " + activeNetInfo.getType() +
                            ",state=" + state);
                    if (state == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                }
            }
        } catch (Throwable ex) {
            ALog.i("Network ex:" + ex.getMessage());
        }
        return false;
    }

    public static int getTimeout(Context context) {
        try {
            ConnectivityManager connectivityManager =
                    (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (connectivityManager != null) {
//NetworkInfo [] networkInfos = connectivityManager.getAllNetworkInfo();
//获取网络的连接情况，断网时会是一个null
                NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                //以下是正确的判断有无网络数据链接的方法，isAvailable仅表示WIFI开关
                if (activeNetInfo != null && (activeNetInfo.getState() != null)) {
                    NetworkInfo.State state = activeNetInfo.getState();
                    ALog.i("Network value is " + activeNetInfo.getType() + ",state=" + state);
                    if (state == NetworkInfo.State.CONNECTED) {
                        //判断WIFI网
                        int value = getNetworkType(activeNetInfo);
                        if (value == WIFI) {
                            ALog.i("Network is TYPE_WIFI");
                            return 7 * 1000;
                        } else if (value == NET_4G) {
                            ALog.i("Network is TYPE_MOBILE");
                            return 9 * 1000;
                        } else if (value == NET_3G) {
                            ALog.i("Network is 3G");
                            return 12 * 1000;
                        } else if (value == NET_2G) {
                            ALog.i("Network is 2G");
                            return 15 * 1000;
                        } else {
                            ALog.i("Network is " + activeNetInfo.getType());
                            return 15 * 1000;
                        }
                    }
                }
            }
        } catch (Throwable ex) {
            ALog.i("Network ex:" + ex.getMessage());
        }
        return 10 * 1000;
    }

    public static int getTimeout2(Context context) {
        try {
            ConnectivityManager connectivityManager =
                    (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (connectivityManager != null) {
                NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetInfo != null) {
                    int value = getNetworkType(activeNetInfo);
                    if (value == WIFI) {
                        ALog.i("Network is TYPE_WIFI");
                        return 7 * 1000;
                    } else if (value == NET_4G) {
                        ALog.i("Network is TYPE_MOBILE");
                        return 9 * 1000;
                    } else if (value == NET_3G) {
                        ALog.i("Network is 3G");
                        return 12 * 1000;
                    } else if (value == NET_2G) {
                        ALog.i("Network is 2G");
                        return 15 * 1000;
                    } else {
                        ALog.i("Network is " + activeNetInfo.getType());
                        return 15 * 1000;
                    }
                }
            }
        } catch (Throwable ex) {
            ALog.i("Network ex:" + ex.getMessage());
        }
        return 10 * 1000;
    }

    private static final int WIFI = 100010;
    private static final int NET_2G = 100020;
    private static final int NET_3G = 100030;
    private static final int NET_4G = 100040;

    private static int getNetworkType(NetworkInfo netInfo) {
        if (netInfo != null) {
            int type = netInfo.getType();
            if (type == ConnectivityManager.TYPE_WIFI
                    || type == ConnectivityManager.TYPE_WIMAX) {
                return WIFI;
            } else if (type == ConnectivityManager.TYPE_MOBILE) {
                int subType = netInfo.getSubtype();
                if (subType == TelephonyManager.NETWORK_TYPE_1xRTT
                        || subType == TelephonyManager.NETWORK_TYPE_UMTS
                        || subType == TelephonyManager.NETWORK_TYPE_EHRPD
                        || subType == TelephonyManager.NETWORK_TYPE_EVDO_0
                        || subType == TelephonyManager.NETWORK_TYPE_EVDO_A
                        || subType == TelephonyManager.NETWORK_TYPE_EVDO_B
                        || subType == TelephonyManager.NETWORK_TYPE_HSDPA
                        || subType == TelephonyManager.NETWORK_TYPE_HSPA
                        || subType == TelephonyManager.NETWORK_TYPE_HSPAP
                        || subType == TelephonyManager.NETWORK_TYPE_HSUPA) {
                    return NET_3G;
                } else if (subType == TelephonyManager.NETWORK_TYPE_GPRS
                        || subType == TelephonyManager.NETWORK_TYPE_CDMA
                        || subType == TelephonyManager.NETWORK_TYPE_EDGE
                        || subType == TelephonyManager.NETWORK_TYPE_IDEN) {
                    return NET_2G;
                } else if (subType == TelephonyManager.NETWORK_TYPE_LTE) {
                    return NET_4G;
                }
            }
        }
        return -100;
    }

    public static class NetErrorType {
        public static final int NATIVE_NOT_NORMAL_EXCEPTION = 0;
        public static final int SocketTimeout = 1;
        public static final int UnknownHost = 2;
        public static final int Connect = 3;
        public static final int SocketException = 4;
        public static final int SSLPeerUnverified = 5;
        public static final int SSLHandshake = 6;
        public static final int NoRouteToHost = 7;
        public static final int ConnectionShutdown = 8;
        public static final int IOException = 9;

        public static final int CANCEL = 10;
        public static final int DataError = 11;
        public static final int Timeout = 12;
        public static final int NoImportantData = 13; // 缺少必要数据

        public static final int NO_NET = 14;
        public static final int WS_NOT_CONNECT = 15;
        public static final int NO_URL = 16;
        public static final int JSON = 17;
    }

    public static int getErrorCodeByExc(final Throwable e) {
        int errorCode = NetErrorType.NATIVE_NOT_NORMAL_EXCEPTION;
        if (e != null) {
            if (!isNetworkConnected2()) {
                errorCode = NetErrorType.NO_NET;
            } else if (e instanceof java.net.SocketTimeoutException) {
                errorCode = NetErrorType.SocketTimeout;
            } else if (e instanceof java.net.UnknownHostException) {
                errorCode = NetErrorType.UnknownHost;
            } else if (e instanceof java.net.ConnectException) {
                errorCode = NetErrorType.Connect;
            } else if (e instanceof java.net.SocketException) {
                errorCode = NetErrorType.SocketException;
            } else if (e instanceof java.net.NoRouteToHostException) {
                errorCode = NetErrorType.NoRouteToHost;
            } else if (e instanceof javax.net.ssl.SSLPeerUnverifiedException) {
                errorCode = NetErrorType.SSLPeerUnverified;
            } else if (e instanceof javax.net.ssl.SSLHandshakeException) {
                errorCode = NetErrorType.SSLHandshake;
            } else if (e instanceof okhttp3.internal.http2.ConnectionShutdownException) {
                errorCode = NetErrorType.ConnectionShutdown;
            } else if (e instanceof java.io.IOException) {
                errorCode = NetErrorType.IOException;
            }
        }
        return errorCode;
    }
}
