package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.gslbsdk.HttpDnsService;
import com.yy.platform.loginlite.ALog;
import com.yy.platform.loginlite.AuthInfo;
import com.yy.platform.loginlite.CHidoReport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.TimeUnit;

import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;


public class HttpClient {
    public static final int DEFAULT_SOCKET_TIMEOUT = 10 * 1000;
    private static OkHttpClient mOkHttpClient = getDefaultOkhttp();

    public final static int RETRY = 3;
    public final static int DURATION = 5 * 6 * 1000;
    public final static int PERTIME = DURATION / RETRY;
    private static int current = DEFAULT_SOCKET_TIMEOUT;
    private static volatile boolean isInit = false;
    private static OkHttpClient mOutHttpClient;
    private static int timeout = DEFAULT_SOCKET_TIMEOUT;

    public static OkHttpClient getInstance() {
        if (mOutHttpClient != null) {
            return mOutHttpClient;
        }
        return mOkHttpClient;
    }

    public static void setOkHttpClient(OkHttpClient client) {
        mOutHttpClient = client;
    }

    public static void init() {
        if (isInit) {
            return;
        }
        if (AuthInfo.getAppContext() != null) {
            timeout = NetworkUtil.getTimeout(AuthInfo.getAppContext());
            current = timeout;
            ALog.e("init() timeout: " + timeout);
        }
        long start = System.currentTimeMillis();
        HttpDnsService mHttpDnsService = HttpDnsService.getService();
        if (mHttpDnsService != null) {
            isInit = true;
            mHttpDnsService.setPreResolveHosts(ServiceUrls.getHost());
            ALog.e("initDns use time " + (System.currentTimeMillis() - start));
        }
    }

    private static OkHttpClient getDefaultOkhttp() {
        init();
        try {
            ALog.e("current: " + current);
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(timeout, TimeUnit.MILLISECONDS);
            builder.readTimeout(timeout, TimeUnit.MILLISECONDS);
            builder.writeTimeout(timeout, TimeUnit.MILLISECONDS);
//            builder.retryOnConnectionFailure(true); // 设置进行连接失败重试
//            TrustManagerUtils.trustManager(builder);
            builder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS,
                    ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));

            builder.dns(OkHttpDns.getInstance());
            return builder.build();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Request makePostRequest(String url, Map<String, String> headers, byte[] datas, int timeout) {
        if (TextUtils.isEmpty(url) || headers == null || datas == null) {
            return null;
        }
        if (mOutHttpClient == null && current != timeout && mOkHttpClient != null) {
            ALog.e("makePostRequest network change, old: " + current + ", new: " + timeout);
            OkHttpClient.Builder builder = mOkHttpClient.newBuilder()
                    .connectTimeout(timeout, TimeUnit.MILLISECONDS)
                    .readTimeout(timeout, TimeUnit.MILLISECONDS)
                    .writeTimeout(timeout, TimeUnit.MILLISECONDS)
                    .connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS,
                            ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT))
                    .dns(OkHttpDns.getInstance());
//            builder.retryOnConnectionFailure(true); // 设置进行连接失败重试
//            TrustManagerUtils.trustManager(builder);
            mOkHttpClient = builder.build();
        }
        current = timeout;
        Request.Builder builder = new Request.Builder().url(url);
        Iterator<Entry<String, String>> iterator = headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry<String, String> entry = iterator.next();
            builder.header(entry.getKey(), entry.getValue());
        }
        builder.post(RequestBody.create(MediaType.parse("application/octet-stream"), datas));
        Request request = builder.build();
        return request;
    }

    public static HttpResponse post(
            String url,
            Map<String, String> headers,
            byte[] datas,
            String tag
    ) {
        return post(url, headers, ServiceUrls.HTTP_CONNECT_TIMEOUT,
                ServiceUrls.HTTP_CONNECT_TIMEOUT, datas, tag);
    }

    public static HttpResponse post(
            String url,
            Map<String, String> headers,
            int connectTimeout,
            int readTimeout,
            byte[] datas,
            String tags
    ) {
        if (TextUtils.isEmpty(url) || headers == null || TextUtils.isEmpty(tags)) {
            return null;
        }
        HttpResponse httpResponse = new HttpResponse();
        HttpURLConnection conn = null;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            if (readTimeout > 0) {
                conn.setReadTimeout(readTimeout);
            } else {
                conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            }
            conn.setDoInput(true);
            conn.setDoOutput(true);
            if (connectTimeout > 0) {
                conn.setConnectTimeout(connectTimeout);
            } else {
                conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            }

            for (Entry<String, String> entry : headers.entrySet()) {
                conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
            OutputStream os = conn.getOutputStream();
            if (datas != null) {
                os.write(datas);
            }
            conn.connect();
        } catch (Exception e) {
            e.printStackTrace();
            httpResponse.errorCode = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            httpResponse.needRetry = true;
            httpResponse.httpCode = 10;
            ALog.i(tags + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
            return httpResponse;
        }

        int code;
        try {
            code = conn.getResponseCode();
            httpResponse.httpCode = code;
            if (code <= 0) {
                httpResponse.httpCode = 11;
            }
            ALog.i(tags + "recvResponse code:" + code);
        } catch (IOException e) {
            httpResponse.errorCode = CHidoReport.QuicResult.CONNECT_IO_EXCEPTION;
            httpResponse.needRetry = true;
            httpResponse.httpCode = 11;
            ALog.i(tags + "recvResponse code exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
            return httpResponse;
        }

        if (code > 400) {
            httpResponse.errorCode = (CHidoReport.QuicResult.RESPONSE_ERROR);
            httpResponse.needRetry = true;
            if (conn != null) {
                conn.disconnect();
            }
            return httpResponse;
        }

        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = conn.getInputStream();
            baos = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            int count;
            while ((count = is.read(data)) != -1) {
                baos.write(data, 0, count);
            }
            httpResponse.responseData = baos.toByteArray();
            httpResponse.needRetry = false;
        } catch (Exception e) {
            httpResponse.errorCode = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            httpResponse.needRetry = true;
            String errInfo = tags + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            return httpResponse;
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return httpResponse;
    }

    public static class HttpResponse {
        public byte[] responseData;
        public int errorCode;
        public int httpCode;
        public boolean needRetry = false;
    }
}
