package com.yy.platform.loginlite.utils;

import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.HttpDnsService;
import com.yy.platform.loginlite.ALog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by kevinkuo on 2018/8/17.
 */

public class GslbDns {

    private static GslbDns mInstance = null;
    private HttpDnsService mHttpDnsService = null;

    private GslbDns() {
    }

    public static GslbDns inst() {
        if (mInstance == null) {
            synchronized (GslbDns.class) {
                if (mInstance == null) {
                    mInstance = new GslbDns();
                }
            }
        }
        return mInstance;
    }

    public List<String> getIps(String hostname) {
        mHttpDnsService = HttpDnsService.getService();
        if (mHttpDnsService != null) {
            try {
                DnsResultInfo info;
                long start = System.currentTimeMillis();
                info = mHttpDnsService.getIpsByHost(hostname);
                long end = System.currentTimeMillis() - start;
                ALog.i("gslbdns use " + end);
                if (info != null && info.mIps != null && info.mIps.length > 0) {
                    List<String> list = new ArrayList<>();
                    Collections.addAll(list, info.mIps);
                    ALog.i("hostname:" + hostname + " mDataSource:" + info.mDataSource +
                            " mErrorCode:" + info.mErrorCode + " res.IPList:" +
                            Arrays.asList(info.mIps));
                    return list;
                }
                ALog.i("getIpsByHost error.hostname:" + hostname + " mErrorCode:" +
                        (info != null ? info.mErrorCode : "null"));
            } catch (Exception e) {
                ALog.i(e.getMessage());
            }
        } else {
            ALog.i("HttpDnsService is null");
        }
        return null;
    }
}
