package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.platform.loginlite.ALog;

public class CodeUtils {

    public static final int UIDDEFAULT = -1;

    public static int parseCode(String code, int defaultCode) {
        int errCode = defaultCode;
        try {
            if (!TextUtils.isEmpty(code)) {
                errCode = Integer.parseInt(code);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            ALog.e("parseInt ex: " + ex.getMessage());
        }
        return errCode;
    }

    public static long parseLongCode(String code, int defaultCode) {
        long errCode = defaultCode;
        try {
            if (!TextUtils.isEmpty(code)) {
                errCode = Long.parseLong(code);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            ALog.e("parseLong ex: " + ex.getMessage());
        }
        return errCode;
    }

    public static final int creditLogin = 1;
    public static final int getSms = 2;
    public static final int smsLogin = 3;
    public static final int thirdLogin = 4;
    public static final int guestLogin = 5;
    public static final int bindMobilePhone = 6;
    public static final int bindThirdToken = 7;
    public static final int param = 8;
    public static final int common = 9;

    private static final int base = 100000;

    public static int makeCode(int code, int type) {
        if (type >= creditLogin && type <= common) {
            return -(type * base + code);
        } else {
            return code;
        }
    }
}
