package com.yy.platform.loginlite;


import com.yy.platform.loginlite.proto.ThirdloginReq;
import com.yy.platform.loginlite.proto.ThirdloginRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.HttpClient;
import com.yy.platform.loginlite.utils.HttpClient.HttpResponse;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThirdInfoUtils;
import com.yy.platform.loginlite.utils.ThreadManager;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/10.
 */
public class ThirdLoginHttp1 implements IThirdLoginCallback, ITask {
    private static final String fun = "Thirdlogin using http ";
    private String traceId = "";
    private String url;
    private ThirdloginReq thirdLoginReq;
    private String channel;
    private String token;
    private int tokenType;
    private String openid;
    private volatile IThirdLoginCallback callback;
    private long startTime;
    private Lock callbackLock;

    private int httpResult = CHidoReport.QuicResult.ENABLE_QUIC;
    private Map<String, String> httpHeaders;

    private final static int RETRY = HttpClient.RETRY;
    private final static int DURATION = HttpClient.DURATION;
    private volatile int index = 0;
    private volatile boolean isStop = false;
    private volatile int networkError = 0;
    private int timeout;

    public ThirdLoginHttp1(
            int timeoutTmp,
            long sTime,
            String channel,
            String token,
            int tokenType,
            String openid,
            String authUrl,
            String extInfo,
            Map<String, String> headers,
            IThirdLoginCallback callback
    ) {
        this.timeout = timeoutTmp;
        this.channel = channel;
        this.token = token;
        this.tokenType = tokenType;
        this.openid = openid;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        thirdLoginReq = ThirdloginReq.newBuilder()
                .setVersion(1)
                .setAppid(AuthInfo.getHeader().getAppId())
                .setChannel(channel)
                .setToken(token)
                .setTokenType(tokenType)
                .setOpenid(openid)
                .setAuthUrl(authUrl)
                .setDeviceid(AuthInfo.getHeader().getDeviceId())
                .setClientSys(AuthInfo.getHeader().getSys())
                .setExtInfo(extInfo)
                .setRegion(AuthInfo.getHeader().getRegion())
                .build();
        url = ServiceUrls.getHttpUrl() + "UdbApp.ThirdloginServer.ThirdloginObj/Thirdlogin";
        httpHeaders = new HashMap<>();
        httpHeaders.put("Context", "Thirdlogin");
        httpHeaders.put("AppId", AuthInfo.getAppId());
        httpHeaders.put("Uid", openid);
        httpHeaders.put("ServiceName", "UdbApp.ThirdloginServer.ThirdloginObj");
        httpHeaders.put("FunctionName", "Thirdlogin");
        httpHeaders.put("ProtoType", "http");
        httpHeaders.put("InstId", "Thirdlogin");
        httpHeaders.put("ServerId", "Thirdlogin");

        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpHeaders.put(header.getKey(), header.getValue());
            }
        }
    }

    private void execute() {
        synchronized (ThirdLoginHttp1.class) {
            if (isStop) {
                ALog.e("ThirdLoginHttp stop");
                return;
            }
        }
        if (!NetworkUtil.isNetworkConnected2()) {
            networkError = networkError + 1;
            ALog.e("network error " + networkError);
        }
        index++;
        traceId = UUID.randomUUID().toString();
        httpHeaders.put("TraceId", traceId);
        long bTime = System.currentTimeMillis();
        ALog.i(fun + "channel:" + channel +
                ", token:" + token + ", tokenType:" + tokenType + ", openid:" + openid +
                ", traceId: " + traceId + ", timeout: " + timeout + ", url: " + url);
        HttpResponse httpResponse = HttpClient.post(url, httpHeaders, timeout, timeout,
                thirdLoginReq.toByteArray(), fun);
        if (httpResponse == null) {
            throw new IllegalArgumentException("url, header or data maybe is null");
        }

        if (httpResponse.needRetry) {
            long useTime = System.currentTimeMillis() - startTime;
            long perTime = System.currentTimeMillis() - bTime;
            int left = (int) (HttpClient.PERTIME - perTime);
            ALog.e(fun + "retry " + index + ", use time " + useTime + ", per time " + left);
            if (index < RETRY && useTime < DURATION && networkError < 2) {
                if (left <= 0) {
                    execute();
                } else {
                    try {
                        Thread.sleep(1000);
                        execute();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        ALog.e(fun + "fail, code " + httpResponse.errorCode);
                        httpResult = httpResponse.errorCode;
                        int code = CodeUtils.makeCode(httpResponse.httpCode, CodeUtils.thirdLogin);
                        onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code,
                                "network error");
                    }
                }
//                mHandler.postDelayed(new Runnable() {
//                    @Override
//                    public void run() {
//                        ThreadManager.executeOnNetWorkThread(new Runnable() {
//                            @Override
//                            public void run() {
//                                execute();
//                            }
//                        });
//                    }
//                }, per);
            } else {
                ALog.e(fun + "fail, code " + httpResponse.errorCode);
                httpResult = httpResponse.errorCode;
                int code = CodeUtils.makeCode(httpResponse.httpCode, CodeUtils.thirdLogin);
                onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code,
                        "network error");
            }
            return;
        }
        ThirdloginRsp res;
        try {
            res = ThirdloginRsp.parseFrom(httpResponse.responseData);
        } catch (Exception e) {
            httpResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpResponse.httpCode, CodeUtils.thirdLogin);
            onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return;
        }

        if (res.getRescode().equals("0")) {
            httpResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "thirdLogin/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = token;

                response.mQuicResult = httpResult;
                response.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }

            try {
                JSONObject jsonData = new JSONObject(res.getData());
                final ThirdInfo info = new ThirdInfo();
                ThirdInfoUtils.unPack(jsonData, info);

                ALog.i(fun + "success,chanel=" + channel + ",thirdAuthSrvCode:" +
                        res.getRescode() + ",thirdAuthSrvDesc:" + res.getMessage() +
                        ",data:" + res.getData() + ",ts=" + info.mTS);

                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
                ThreadManager.executeOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        onSuccess(0, info);
                        AntiHelper.checkAntiCodeHw(info.mUid);
                    }
                });
            } catch (Exception e) {
                httpResult = CHidoReport.QuicResult.AUTH_ERROR;
                ALog.i(fun + "fail, chanel=" + channel + ", exceptionDesc:" + e.getMessage());
                int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
                onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE,
                        errorCode, e.getMessage());
            }
        } else {
            ALog.i(fun + "fail,chanel=" + channel +
                    ", thidAuthSrvCode:" + res.getRescode() +
                    ", thirdAuthSrvDesc:" + res.getMessage());
            httpResult = CHidoReport.QuicResult.AUTH_ERROR;
            int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
            onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, errorCode, res.getMessage());
        }
    }

    private void onThirdLoginFailed(long bTime, final int errType, final int errCode,
                                    final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "thirdLogin/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = token;

            response.mQuicResult = httpResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    @Override
    public void onSuccess(int requestId, ThirdInfo thirdInfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, thirdInfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void cancel() {
        isStop = true;
        callback = null;
    }

    @Override
    public void run() {
        execute();
    }
}
