package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.ThirdloginReq;
import com.yy.platform.loginlite.proto.ThirdloginRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThirdInfoUtils;
import com.yy.platform.loginlite.utils.ThreadManager;

import org.json.JSONObject;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class ThirdLoginHttp implements IThirdLoginCallback {
    private static final String fun = "Thirdlogin using http ";
    private String traceId = "";
    private String url;
    private ThirdloginReq thirdLoginReq;

    public ThirdLoginHttp(long sTime, String channel, String token, int tokenType, String openid,
                          String authUrl, String extInfo, Map<String, String> headers,
                          IThirdLoginCallback callback) {
        this.channel = channel;
        this.token = token;
        this.tokenType = tokenType;
        this.openid = openid;
        this.authUrl = authUrl;
        this.extInfo = extInfo;
        this.headers = headers;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        thirdLoginReq = ThirdloginReq.newBuilder()
                .setVersion(1)
                .setAppid(AuthInfo.getHeader().getAppId())
                .setChannel(channel)
                .setToken(token)
                .setTokenType(tokenType)
                .setOpenid(openid)
                .setAuthUrl(authUrl)
                .setDeviceid(AuthInfo.getHeader().getDeviceId())
                .setClientSys(AuthInfo.getHeader().getSys())
                .setExtInfo(extInfo)
                .setRegion(AuthInfo.getHeader().getRegion())
                .build();
        url = ServiceUrls.getHttpUrl() + "UdbApp.ThirdloginServer.ThirdloginObj/Thirdlogin";
    }

    public int run() {
        long bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);

        traceId = UUID.randomUUID().toString();

        ALog.i(fun + "channel:" + channel +
                ", token:" + token + ", tokenType:" + tokenType + ", openid:" + openid +
                ", traceId: " + traceId + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "Thirdlogin");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("Uid", openid);
            conn.addRequestProperty("ServiceName", "UdbApp.ThirdloginServer.ThirdloginObj");
            conn.addRequestProperty("FunctionName", "Thirdlogin");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
            conn.addRequestProperty("InstId", "Thirdlogin");
            conn.addRequestProperty("ServerId", "Thirdlogin");
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    conn.addRequestProperty(header.getKey(), header.getValue());
                }
            }

            OutputStream os = conn.getOutputStream();
            thirdLoginReq.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    quicHttp.getResponseCode(), errInfo, callback);
                if (conn != null) {
                    conn.disconnect();
                }
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            ALog.i(fun + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
//            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
            return quicResult;
        }

        ThirdloginRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = ThirdloginRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onThirdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        if (res.getRescode().equals("0")) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "thirdLogin/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = token;

                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }

            try {
                JSONObject jsonData = new JSONObject(res.getData());
                final ThirdInfo info = new ThirdInfo();
                ThirdInfoUtils.unPack(jsonData, info);

                ALog.i(fun + "success,chanel=" + channel + ",thirdAuthSrvCode:" +
                        res.getRescode() + ",thirdAuthSrvDesc:" + res.getMessage() +
                        ",data:" + res.getData() + ",ts=" + info.mTS);

                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
                ThreadManager.executeOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        onSuccess(0, info);
                        AntiHelper.checkAntiCodeHw(info.mUid);
                    }
                });
            } catch (Exception e) {
                quicResult = CHidoReport.QuicResult.AUTH_ERROR;
                ALog.i(fun + "fail, chanel=" + channel + ", exceptionDesc:" + e.getMessage());
                int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
                onThirdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
                        errorCode, e.getMessage());
            }
        } else {
            ALog.i(fun + "fail,chanel=" + channel +
                    ", thidAuthSrvCode:" + res.getRescode() +
                    ", thirdAuthSrvDesc:" + res.getMessage());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
            onThirdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
                    errorCode, res.getMessage());
        }
        return quicResult;
    }

    public void onThirdLoginFailed(long bTime, int errType, int errCode, String description) {
        onThirdLoginFailed(bTime, traceId, errType, errCode, description);
    }

    private void onThirdLoginFailed(long bTime, String traceId, final int errType, final int errCode,
                                    final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "thirdLogin/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = token;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private String channel;
    private String token;
    private int tokenType;
    private String openid;
    private String authUrl;
    private String extInfo;

    private Map<String, String> headers = null;

    IThirdLoginCallback callback;

    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    private long startTime = 0;
    private boolean isTimeout = false;
    private Lock callbackLock = null;

    @Override
    public void onSuccess(int requestId, ThirdInfo thirdInfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, thirdInfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
