package com.yy.platform.loginlite;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.ThirdloginReq;
import com.yy.platform.loginlite.proto.ThirdloginRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ThirdInfoUtils;
import com.yy.platform.loginlite.utils.ThreadManager;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class ThirdLoginByOkHttp extends BaseOkHttp implements IThirdLoginCallback {
    private static final String fun = "Thirdlogin ";
    private String path;
    private ThirdloginReq thirdLoginReq;
    private Map<String, String> map;
    private int timeout;
    private long bTime;

    public ThirdLoginByOkHttp(
            int timeout, long sTime, String channel, String token, int tokenType, String openid,
            String authUrl, String extInfo, Map<String, String> headers,
            IThirdLoginCallback callback
    ) {
        this.timeout = timeout;
        this.channel = channel;
        this.token = token;
        this.tokenType = tokenType;
        this.openid = openid;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        thirdLoginReq = ThirdloginReq.newBuilder()
                .setVersion(1)
                .setAppid(AuthInfo.getHeader().getAppId())
                .setChannel(channel)
                .setToken(token)
                .setTokenType(tokenType)
                .setOpenid(openid)
                .setAuthUrl(authUrl)
                .setDeviceid(AuthInfo.getHeader().getDeviceId())
                .setClientSys(AuthInfo.getHeader().getSys())
                .setExtInfo(extInfo)
                .setRegion(AuthInfo.getHeader().getRegion())
                .build();
        path = "UdbApp.ThirdloginServer.ThirdloginObj/Thirdlogin";

        map = new HashMap<>();
        map.put("Context", "Thirdlogin");
        map.put("AppId", AuthInfo.getAppId());
        map.put("Uid", openid);
        map.put("ServiceName", "UdbApp.ThirdloginServer.ThirdloginObj");
        map.put("FunctionName", "Thirdlogin");
        map.put("ProtoType", "http");
//        map.put("InstId", "Thirdlogin");
//        map.put("ServerId", "Thirdlogin");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                map.put(header.getKey(), header.getValue());
            }
        }

        tag = fun;
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        ALog.i(fun + "channel:" + channel + ", token:" + token + ", tokenType:" + tokenType +
                ", openid:" + openid);
        executeInner(path, map, thirdLoginReq.toByteArray(), timeout);
    }

    private void onThirdLoginFailed(long bTime, final int errType, final int errCode,
                                    final String description) {
        final long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            long reportStart = System.currentTimeMillis();
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = token;

            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
            ALog.e(fun + "report fail time: " + (System.currentTimeMillis() - reportStart));
        }
        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private String channel;
    private String token;
    private int tokenType;
    private String openid;
    private IThirdLoginCallback callback;


    private long startTime;
    private Lock callbackLock = null;

    @Override
    public void onSuccess(int requestId, ThirdInfo thirdInfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, thirdInfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    private String getEventType() {
        return compose(EventTypeUtils.thirdLogin);
    }

    @Override
    public void onSuccess(Call call, byte[] data, int httpCode, long useTime) {
        ThirdloginRsp res;
        try {
            res = ThirdloginRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            String msg = e.getMessage();
            String errInfo = fun + "InvalidProtocolBufferException: " + msg + ", code: " + httpCode;
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpCode, CodeUtils.thirdLogin);
            onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code, msg);
            return;
        }

        if (res.getRescode().equals("0")) {
            final long eTime = System.currentTimeMillis();
            try {
                JSONObject jsonData = new JSONObject(res.getData());
                final ThirdInfo info = new ThirdInfo();
                ThirdInfoUtils.unPack(jsonData, info);

                ALog.i(fun + "success,chanel=" + channel + ",thirdAuthSrvCode:" +
                        res.getRescode() + ",thirdAuthSrvDesc:" + res.getMessage() +
                        ",data:" + res.getData() + ",ts=" + info.mTS);

                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
                if (bTime > 0) {
                    long reportStart = System.currentTimeMillis();
                    CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                    report.mRtt = eTime - bTime;
                    report.mEventType = getEventType();
                    report.mSucceed = 0;
                    report.mErrType = 0;
                    report.mErrCode = 0;
                    report.mTraceId = traceId;
                    report.mChannel = ChannelName.HTTP;
                    report.mUserInfo = token;

                    report.mTotalRtt = eTime - startTime;
                    CHidoReport.getInstance().report2Hido(report);
                    CHidoReport.getInstance().report2Metric(report);
                    ALog.e(fun + "report success time: " + (System.currentTimeMillis() - reportStart));
                }

                ThreadManager.executeOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        onSuccess(0, info);
                        AntiHelper.checkAntiCodeHw(info.mUid);
                    }
                });
            } catch (JSONException e) {
                String jsonMsg = e.getMessage();
                int errorCode = CodeUtils.makeCode(NetworkUtil.NetErrorType.JSON,
                        CodeUtils.thirdLogin);
                ALog.i(fun + "JSONException: " + jsonMsg + ", chanel=" + channel +
                        ", httpCode: " + httpCode + ", resCode: " + res.getRescode());
                onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE,
                        errorCode, jsonMsg);
            }
        } else {
            ALog.i(fun + "fail,chanel=" + channel +
                    ", thidAuthSrvCode:" + res.getRescode() +
                    ", thirdAuthSrvDesc:" + res.getMessage());
            int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
            onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    errorCode, res.getMessage());
        }
    }

    @Override
    public void onFail(int code, String message, long useTime) {
        int busiCode = CodeUtils.makeCode(code, CodeUtils.thirdLogin);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        int busiCode = CodeUtils.makeCode(code, CodeUtils.thirdLogin);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onThirdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }
}
