package com.yy.platform.loginlite;

/**
 * 互联的第三方账号信息
 */
public class ThirdInfo extends HagoInfo {

    /**
     * 用户的YY uid,注册/登录成功后返回
     */
    public long mUid;
    /**
     * 是否存量用户
     */
    public boolean mIsNewUser;

    /**
     * 渠道，取如下值之一:
     * {facebook,google,twitter,instagram,weibo,qq,wechat}
     */
    public String mChannel;

    /**
     * 第三方返回的帐号信息，json串，有如下固定的字段名:
     * {
     * "openid": "XXXXXXXXXXXXXXXX",
     * "unionid": "XXXXXXXX",
     * "nickname": "Roven",
     * "sex": "男",
     * "avatar": "http://thirdqq.qlogo.cn/qqapp/XXXXX",
     * "accessToken": "XXXXXXXXXXXXXXX"
     * }
     */
    public String mThirdInfo;

    /**
     * 登录时的时间戳
     */
    public long mTS = 0L;

    /**
     * 凭证
     */
    public String mCredit;

    /**
     * 业务透传到客户端的参数
     */
    public String mBizParam;

    /**
     * 扩展json串，如{"region":"br"}
     */
    public String mExt = "";

    /**
     * 是否授权
     */
    public boolean isAuthed = false;

    @Override
    public String toString() {
        return "ThirdInfo{" +
                "mUid=" + mUid +
                ", realCountry='" + realCountry + '\'' +
                ", registerCountry='" + registerCountry + '\'' +
                ", mIsNewUser=" + mIsNewUser +
                ", mChannel='" + mChannel + '\'' +
                ", mThirdInfo='" + mThirdInfo + '\'' +
                ", mTS=" + mTS +
                ", mCredit='" + mCredit + '\'' +
                ", mBizParam='" + mBizParam + '\'' +
                ", mExt='" + mExt + '\'' +
                ", lifecycle=" + lifecycle +
                ", localHost='" + localHost + '\'' +
                ", registerHost='" + registerHost + '\'' +
                ", registerIdc='" + registerIdc + '\'' +
                ", cproxyHost='" + cproxyHost + '\'' +
                ", gameHost='" + gameHost + '\'' +
                ", turnoverHost='" + turnoverHost + '\'' +
                ", lcid='" + lcid + '\'' +
                ", st='" + st + '\'' +
                ", isAuthed=" + isAuthed  +
                ", session='" + session + '\'' +
                '}';
    }
}
