//package com.yy.platform.loginlite;
//
//import com.yy.platform.loginlite.proto.ClientRegisterErr;
//import com.yy.platform.loginlite.proto.SmsRegisterReq;
//import com.yy.platform.loginlite.proto.SmsRegisterRsp;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//import com.yy.platform.loginlite.utils.UserInfoUtils;
//import com.yy.platform.loginlite.utils.YYLoginliteUtils;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/11.
// */
//
//public class SmsRegisterQuic implements ISmsRegisterCallback {
//
//    private String account;
//    private String smsCode;
//    private String password;
//    private ISmsRegisterCallback callback;
//    private static final String fun = "smsRegister using quic ";
//    private IQuicHandler quicHttp = null;
//
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//    private long startTime = 0;
//    private boolean isTimeout = false;
//    private Lock callbackLock = null;
//    private String traceId = "";
//
//    public SmsRegisterQuic(
//            IQuicHandler handler,
//            long sTime,
//            String account,
//            String smsCode,
//            String password,
//            ISmsRegisterCallback callback
//    ) {
//        this.quicHttp = handler;
//        this.account = account;
//        this.smsCode = smsCode;
//        this.password = password;
//        this.callback = callback;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int run() {
//        long bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        SmsRegisterReq req = SmsRegisterReq.newBuilder()
//                .setUser(account)
//                .setSmscode(smsCode)
//                .setSha1Pwd(YYLoginliteUtils.getPasswdSha1(password))
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getQuitUrl() + "UdbApp.RegisterServer.RegisterObj/RegisterBySms";
//        AuthCore.sLog.i(AuthCore.TAG, fun + "account:" + account +
//                ", traceId: " + traceId + ", url: " + url);
//
//        quicHttp.init();
//        HashMap<String, String> header = new HashMap<>();
//        header.put("Context", "RegisterBySms");
//        header.put("AppId", AuthInfo.getAppId());
//        header.put("Uid", account);
//        header.put("ServiceName", "UdbApp.RegisterServer.RegisterObj");
//        header.put("FunctionName", "RegisterBySms");
//        header.put("TraceId", traceId);
//        header.put("ProtoType", "Quic");
//        header.put("InstId", "RegisterBySms");
//        header.put("ServerId", "RegisterBySms");
//
//        try {
//            quicHttp.connect(url, "POST", header, req.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            String errInfo = fun + "connect exception, " + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            quicHttp.disconnect();
////            onSmsRegisterFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            String errInfo = fun + "getResponseCode exception, " + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//        }
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            String errInfo = fun + "recvResponse code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            quicHttp.disconnect();
////            onSmsRegisterFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    quicHttp.getResponseCode(), errInfo, callback);
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            String errInfo = fun + "connect err,code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            quicHttp.disconnect();
////            onSmsRegisterFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo, callback);
//            return quicResult;
//        }
//
//        SmsRegisterRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = SmsRegisterRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, " + "errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onSmsRegisterFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            quicHttp.disconnect();
//        }
//
//        ALog.i(fun + "call success,acc=" + account +
//                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//
//        if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = eTime - bTime;
//                response.mEventType = "smsRegister/quic";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//                response.mUserInfo = account;
//
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
//                CHidoReport.getInstance().report2Hido(response);
//                CHidoReport.getInstance().report2Metric(response);
//            }
//
//            final YYInfo info = new YYInfo();
//            UserInfoUtils.unPack(res.getUserData(), info);
//            info.mTS = res.getServerTime();
//            info.extjsstr = res.getExt();
//
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onSuccess(0, info);
//                    AntiHelper.checkAntiCodeHw(info.mUid);
//                }
//            });
//        } else {
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onSmsRegisterFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_REGISTER_CODE,
//                    res.getErrcodeValue(), res.getDescription());
//        }
//
//        return quicResult;
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onSmsRegisterFailed(long bTime, int errType, int errCode, String description) {
//        onSmsRegisterFailed(bTime, traceId, errType, errCode, description);
//    }
//
//    private void onSmsRegisterFailed(long bTime, String traceId, final int errType, final int errCode,
//                                     final String description) {
//        long eTime = System.currentTimeMillis();
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "smsRegister/quic";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = account;
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//        return;
//    }
//
//
//    @Override
//    public void onSuccess(int requestId, YYInfo uinfo) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId, uinfo);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
