package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.ClientRegisterErr;
import com.yy.platform.loginlite.proto.SmsRegisterReq;
import com.yy.platform.loginlite.proto.SmsRegisterRsp;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;
import com.yy.platform.loginlite.utils.YYLoginliteUtils;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/11.
 */

public class SmsRegisterHttp extends BaseHttp implements ISmsRegisterCallback {

    private static final String fun = "RegisterBySms using http ";
    private String traceId = "";

    public SmsRegisterHttp(long sTime, String account, String smsCode, String password, ISmsRegisterCallback callback) {
        super(callback);
        this.account = account;
        this.smsCode = smsCode;
        this.password = password;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;
    }

    public int execute() {
        long bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);

        SmsRegisterReq req = SmsRegisterReq.newBuilder()
                .setUser(account)
                .setSmscode(smsCode)
                .setSha1Pwd(YYLoginliteUtils.getPasswdSha1(password))
                .setPrheader(AuthInfo.getHeader())
                .build();


        traceId = UUID.randomUUID().toString();
        String url = ServiceUrls.getHttpUrl() + "UdbApp.RegisterServer.RegisterObj/RegisterBySms";
        ALog.i(fun + "account:" + account +
                ", smsCode:" + smsCode + ", traceId: " + traceId + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "RegisterBySms");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("Uid", account);
            conn.addRequestProperty("ServiceName", "UdbApp.RegisterServer.RegisterObj");
            conn.addRequestProperty("FunctionName", "RegisterBySms");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
            conn.addRequestProperty("InstId", "RegisterBySms");
            conn.addRequestProperty("ServerId", "RegisterBySms");

            OutputStream os = conn.getOutputStream();
            req.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
                if (conn != null) {
                    conn.disconnect();
                }
//            onSmsRegisterFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    quicHttp.getResponseCode(), errInfo, callback);
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            String errInfo = fun + "connect exception, " + e.getMessage();
            ALog.i(errInfo);
            if (conn != null) {
                conn.disconnect();
            }
//            onSmsRegisterFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
            return quicResult;
        }


        SmsRegisterRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = SmsRegisterRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onSmsRegisterFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        ALog.i(fun + "call success,acc=" + account +
                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "smsRegister/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = account;

                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }

            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            info.mTS = res.getServerTime();
            info.extjsstr = res.getExt();

            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else {
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onSmsRegisterFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_REGISTER_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }

        return quicResult;
    }

    public void onSmsRegisterFailed(long bTime, int errType, int errCode, String description) {
        onSmsRegisterFailed(bTime, traceId, errType, errCode, description);
    }

    private void onSmsRegisterFailed(long bTime, String traceId, final int errType, final int errCode,
                                     final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "smsRegister/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = account;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
        return;
    }

    private String account;
    private String smsCode;
    private String password;
    private ISmsRegisterCallback callback;

    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    private long startTime = 0;
    private boolean isTimeout = false;
    private Lock callbackLock = null;

    @Override
    public void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
