//package com.yy.platform.loginlite;
//
//import android.content.Context;
//import android.text.TextUtils;
//
//import com.yy.platform.loginlite.proto.Errcode;
//import com.yy.platform.loginlite.proto.SmsLoginReq;
//import com.yy.platform.loginlite.proto.SmsLoginRsp;
//import com.yy.platform.loginlite.utils.Constants;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//import com.yy.platform.loginlite.utils.UserInfoUtils;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/10.
// */
//
//public class SmsLoginQuic implements ISmsLoginCallback {
//    private String userPhoneNumber;
//    private String smsCode;
//    private String dynCode;
//    private String otp;
//    private SmsLoginCallbackProxy callback;
//    private long startTime;
//    private boolean isTimeout = false;
//    private Lock callbackLock;
//    private IQuicHandler quicHttp;
//    private String traceId;
//    private Context context;
//    private long bTime;
//    private static final String fun = "LoginBySms using quic ";
//
//    public SmsLoginQuic(
//            Context context,
//            IQuicHandler handler,
//            long sTime,
//            String userPhoneNumber,
//            String smsCode,
//            String dynCode,
//            String otp,
//            SmsLoginCallbackProxy callback
//    ) {
//        this.context = context;
//        this.quicHttp = handler;
//        this.userPhoneNumber = userPhoneNumber;
//        this.smsCode = smsCode;
//        this.dynCode = dynCode;
//        this.otp = otp;
//        this.callback = callback;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int run() {
//        bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        SmsLoginReq smsLoginReq = SmsLoginReq.newBuilder()
//                .setUser(userPhoneNumber)
//                .setSmscode(smsCode)
//                .setPrheader(AuthInfo.getHeader())
//                .setDynCode(dynCode == null ? "" : dynCode)
//                .putExtmap(Constants.KEY_OTP, (otp == null ? "" : otp))
//                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
//                .build();
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getQuitUrl() + "UdbApp.LoginServer.LoginObj/LoginBySms";
//        ALog.i(fun + "userPhoneNumber:" + userPhoneNumber + ", traceId: " + traceId +
//                ", otp: " + (otp == null ? "" : otp) + ", url: " + url);
//
//        if (!TextUtils.isEmpty(dynCode)) {
//            ALog.e(fun + "二次验证成功");
//        }
//        if (TextUtils.isEmpty(smsCode)) {
//            ALog.i(fun + "lack of sms code");
//        }
//
//        quicHttp.init();
//        HashMap<String, String> header = new HashMap<>();
//
//        header.put("Context", "LoginBySms");
//        header.put("AppId", AuthInfo.getAppId());
//        header.put("Uid", userPhoneNumber);
//        header.put("ServiceName", "UdbApp.LoginServer.LoginObj");
//        header.put("FunctionName", "LoginBySms");
//        header.put("TraceId", traceId);
//        header.put("ProtoType", "Quic");
//        header.put("InstId", "LoginBySms");
//        header.put("ServerId", "LoginBySms");
//
//        try {
//            quicHttp.connect(url, "POST", header, smsLoginReq.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            String errInfo = fun + "connect exception, " + e.getMessage();
//            ALog.i(errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            String errInfo = fun + "getResponseCode exception, " + e.getMessage();
//            ALog.i(errInfo);
//        }
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            String errInfo = fun + "recvResponse code:" + code;
//            ALog.i(errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    quicHttp.getResponseCode(), errInfo, callback);
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            String errInfo = fun + "connect err code: " + code;
//            ALog.i(errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo, callback);
//            return quicResult;
//        }
//
//        SmsLoginRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = SmsLoginRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onSmdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//        ALog.i(fun + "success,phoNo=" +
//                userPhoneNumber + ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" +
//                res.getDescription());
//
//        if (res.getErrcode() == Errcode.SUCCESS) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = eTime - bTime;
//                response.mEventType = "smsLogin";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//                response.mUserInfo = userPhoneNumber;
//
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
////                CHidoReport.getInstance().report2Hido(response);
////                CHidoReport.getInstance().report2Metric(response);
//                callback.reportSuccess(response);
//            }
//            final YYInfo info = new YYInfo();
//            UserInfoUtils.unPack(res.getUserData(), info);
//            //单位s
//            info.mTS = res.getServerTime();
//            info.mIsNewUser = res.getIsnewuser() == 1 ? true : false;
//            info.mUrl = res.getUrl();
//            info.extjsstr = res.getExtjsstr();
//
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    callback.saveAuthInfo(info, ChannelName.QUIC);
//                    onSuccess(0, info);
//                }
//            });
//        } else if (res.getErrcode() == Errcode.NEXT_VER) {
//            //需要二次验证
//            ALog.e(fun + "需要二次验证");
//            final SmsLoginRsp resp = res;
//            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
//            final NextVerify nextVerify = new NextVerify();
//            nextVerify.mDynVer = res.getDynVer();
//            AuthCore.setSessionData(res.getSessiondata());
//            final int errCode = res.getErrcodeValue();
//            final String errDescription = res.getDescription();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    Runnable runnable = new Runnable() {
//                        @Override
//                        public void run() {
//                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
//                        }
//                    };
//                    if (callback.count == 1) {
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    } else if (callback.count > 1) {
//                        if (callback.isSuccess()) {
//                            return;
//                        }
//                        callback.setSuccess(true);
//                        if (callback.isNext()) {
//                            return;
//                        }
//                        callback.setNext(true);
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    }
////                    onNext(0, errCode, errDescription, nextVerify);
//                }
//            });
//        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
//            //二次验证码失败
//            final SmsLoginRsp resp = res;
//            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
//            final NextVerify nextVerify = new NextVerify();
//            nextVerify.mDynVer = res.getDynVer();
//            if (TextUtils.isEmpty(nextVerify.mDynVer)) {
//                ALog.e(fun + "二次验证码失败");
//            } else {
//                ALog.e(fun + "二次验证码失败，需要再次验证");
//            }
//            AuthCore.setSessionData(res.getSessiondata());
//            final int errCode = res.getErrcodeValue();
//            final String errDescription = res.getDescription();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    Runnable runnable = new Runnable() {
//                        @Override
//                        public void run() {
//                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
//                        }
//                    };
//                    if (callback.count == 1) {
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    } else if (callback.count > 1) {
//                        if (callback.isSuccess()) {
//                            return;
//                        }
//                        callback.setSuccess(true);
//                        if (callback.isNext()) {
//                            return;
//                        }
//                        callback.setNext(true);
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    }
//                }
//            });
//        } else {
//            AuthCore.setSessionData(res.getSessiondata());
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onSmdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
//                    res.getErrcodeValue(), res.getDescription());
//        }
//
//        return quicResult;
//    }
//
//    private void reportNext(int errType, int errCode, String description) {
//        long eTime = System.currentTimeMillis();
//        if (NetworkUtil.isNetworkConnected()) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            if (callback.count == 1) {
//                response.mEventType = "smsLogin/quic";
//            } else if (callback.count > 1) {
//                response.mEventType = "smsLogin/mquic";
//            }
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = userPhoneNumber;
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onSmdLoginFailed(long bTime, int errType, int errCode, String description) {
//        onSmdLoginFailed(bTime, traceId, errType, errCode, description);
//    }
//
//    private void onSmdLoginFailed(long bTime, String traceId, final int errType, final int errCode,
//                                  final String description) {
//        long eTime = System.currentTimeMillis();
//
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "smsLogin";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = userPhoneNumber;
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
////            CHidoReport.getInstance().report2Hido(response);
////            CHidoReport.getInstance().report2Metric(response);
//            callback.addFailResponse(response);
//        }
//
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//    }
//
//
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//
//    @Override
//    public void onSuccess(int requestId, YYInfo uinfo) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId, uinfo, ChannelName.QUIC);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
////        callbackLock.lock();
////        if (callback != null) {
////            callback.onNext(requestId, authCode, authDesc, dynVerify, ChannelName.QUIC);
////        }
////        callback = null;
////        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc, ChannelName.QUIC);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
