package com.yy.platform.loginlite;

import android.content.Context;
import android.text.TextUtils;

import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.SmsLoginReq;
import com.yy.platform.loginlite.proto.SmsLoginRsp;
import com.yy.platform.loginlite.utils.Constants;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class SmsLoginHttp extends BaseHttp implements ISmsLoginCallback {
    private String userPhoneNumber;
    private String smsCode;
    private String otp;
    private ISmsLoginCallback callback;
    private long startTime;
    private Lock callbackLock;
    private String traceId;
    private Context context;
    private long bTime;
    private static final String fun = "LoginBySms using http ";
    private SmsLoginReq smsLoginReq;
    private String url;

    public SmsLoginHttp(
            Context context,
            long sTime,
            String userPhoneNumber,
            String smsCode,
            String dynCode,
            String otp,
            ISmsLoginCallback callback
    ) {
        super(callback);
        this.context = context;
        this.userPhoneNumber = userPhoneNumber;
        this.smsCode = smsCode;
        this.callback = callback;
        this.otp = otp;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        smsLoginReq = SmsLoginReq.newBuilder()
                .setUser(userPhoneNumber)
                .setSmscode(smsCode)
                .setPrheader(AuthInfo.getHeader())
                .setDynCode(dynCode == null ? "" : dynCode)
                .putExtmap(Constants.KEY_OTP, (otp == null ? "" : otp))
                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
                .build();
        url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginBySms";
        if (!TextUtils.isEmpty(dynCode)) {
            ALog.e(fun + "二次验证成功");
        }
    }

    public int execute() {
        bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);
        traceId = UUID.randomUUID().toString();
        ALog.i(fun + "userPhoneNumber:" + userPhoneNumber +
                ", traceId: " + traceId + ", otp: " + (otp == null ? "" : otp) + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "LoginBySms");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("Uid", userPhoneNumber);
            conn.addRequestProperty("ServiceName", "UdbApp.LoginServer.LoginObj");
            conn.addRequestProperty("FunctionName", "LoginBySms");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
            conn.addRequestProperty("InstId", "LoginBySms");
            conn.addRequestProperty("ServerId", "LoginBySms");

            OutputStream os = conn.getOutputStream();
            smsLoginReq.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
                if (conn != null) {
                    conn.disconnect();
                }
//            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    quicHttp.getResponseCode(), errInfo, callback);
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            String errInfo = fun + "connect exception, " + e.getMessage();
            ALog.i(errInfo);
            if (conn != null) {
                conn.disconnect();
            }
//            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
            return quicResult;
        }

        SmsLoginRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = SmsLoginRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onSmdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        ALog.i(fun + "success,phoNo=" + userPhoneNumber + ",authSrvCode:" + res.getErrcode() +
                ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();

            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "smsLogin/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = userPhoneNumber;

                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }
            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            //单位s
            info.mTS = res.getServerTime();
            info.mIsNewUser = res.getIsnewuser() == 1 ? true : false;
            info.mUrl = res.getUrl();
            info.extjsstr = res.getExtjsstr();
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else if (res.getErrcode() == Errcode.NEXT_VER) {
            //需要二次验证
            ALog.e(fun + "需要二次验证");
            final SmsLoginRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
                            otp, callback, runnable);
//                    if (callback.count == 1) {
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    } else if (callback.count > 1) {
//                        if (callback.isSuccess()) {
//                            return;
//                        }
//                        callback.setSuccess(true);
//                        if (callback.isNext()) {
//                            return;
//                        }
//                        callback.setNext(true);
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    }
                }
            });
        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
            //二次验证码失败
            final SmsLoginRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            if (TextUtils.isEmpty(nextVerify.mDynVer)) {
                ALog.e(fun + "二次验证码失败");
            } else {
                ALog.e(fun + "二次验证码失败，需要再次验证");
            }
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
                            otp, callback, runnable);
//                    if (callback.count == 1) {
//
//                    } else if (callback.count > 1) {
//                        if (callback.isSuccess()) {
//                            return;
//                        }
//                        callback.setSuccess(true);
//                        if (callback.isNext()) {
//                            return;
//                        }
//                        callback.setNext(true);
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    }
//                    onNext(0, errCode, errDescription, nextVerify);
                }
            });
        } else {
            AuthCore.setSessionData(res.getSessiondata());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onSmdLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }

        return quicResult;
    }

    public void onSmdLoginFailed(long bTime, int errType, int errCode, String description) {
        onSmdLoginFailed(bTime, traceId, errType, errCode, description);
    }

    private void reportNext(int errType, int errCode, String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2()) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "smsLogin/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }
    }

    private void onSmdLoginFailed(long bTime, String traceId, final int errType, final int errCode,
                                  final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "smsLogin/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    @Override
    public void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onNext(requestId, authCode, authDesc, dynVerify, this);
//        }
//        callback = null;
//        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
