package com.yy.platform.loginlite;


public class SmsLoginCallbackProxy extends CallbackProxy<ISmsLoginCallback> {

    private volatile boolean isSaveInfo = false;

    public SmsLoginCallbackProxy(ISmsLoginCallback callback) {
        super(callback);
    }

    public ISmsLoginCallback getCallback() {
        return callback;
    }

    public void saveAuthInfo(YYInfo info, String channel) {
        if (count == 1) {
            ALog.i(channel + " smsLogin save AuthInfo");
        } else {
            if (isSaveInfo) {
                return;
            }
            isSaveInfo = true;
            ALog.i(channel + " smsLogin save AuthInfo");
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
            AntiHelper.checkAntiCodeHw(info.mUid);
        }
    }

    public void onSuccess(int requestId, YYInfo uinfo, String channel) {
        if (channel.equals(ChannelName.HTTP)) {
            setHttpResult(true);
        } else if (channel.equals(ChannelName.QUIC)) {
            setQuicResult(true);
        }
        if (isSuccess()) {
            return;
        }
        setSuccess(true);
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
    }

    public void onFail(int requestId, int codeType, int resCode, String resDesc, String channel) {
        if (channel.equals(ChannelName.HTTP)) {
            setHttpResult(false);
        } else if (channel.equals(ChannelName.QUIC)) {
            setQuicResult(false);
        }
        ALog.i("smsLogin onFail count=" + count + ", failCount=" + failCount + ", isSuccess=" + isSuccess());
        failCount--;
        if (count == 1) {
            if (callback != null) {
                callback.onFail(requestId, codeType, resCode, resDesc);
            }
        } else {
            if (isSuccess()) {
                return;
            }
            if (failCount == 0) {
                if (callback != null) {
                    callback.onFail(requestId, codeType, resCode, resDesc);
                }
                reportFail();
            }
        }
    }
}
