package com.yy.platform.loginlite;

import android.content.Context;
import android.text.TextUtils;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.SmsLoginReq;
import com.yy.platform.loginlite.proto.SmsLoginRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.Constants;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class SmsLoginByOkHttp extends BaseOkHttp implements ISmsLoginCallback {
    private String userPhoneNumber;
    private String smsCode;
    private String otp;
    private ISmsLoginCallback callback;
    private long startTime;
    private Lock callbackLock;
    private Context context;
    private long bTime;
    private static final String fun = "LoginBySms ";
    private SmsLoginReq smsLoginReq;
    private String path;
    private int timeout;
    private Map<String, String> map;


    public SmsLoginByOkHttp(
            int timeout,
            Context context,
            long sTime,
            String userPhoneNumber,
            String smsCode,
            String dynCode,
            String otp,
            ISmsLoginCallback callback
    ) {
        this.timeout = timeout;
        this.context = context;
        this.userPhoneNumber = userPhoneNumber;
        this.smsCode = smsCode;
        this.callback = callback;
        this.otp = otp;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        smsLoginReq = SmsLoginReq.newBuilder()
                .setUser(userPhoneNumber)
                .setSmscode(smsCode)
                .setPrheader(AuthInfo.getHeader())
                .setDynCode(dynCode == null ? "" : dynCode)
                .putExtmap(Constants.KEY_OTP, (otp == null ? "" : otp))
                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
                .build();
        path = "UdbApp.LoginServer.LoginObj/LoginBySms";
        if (!TextUtils.isEmpty(dynCode)) {
            ALog.e(fun + "二次验证成功");
        }
        map = new HashMap<>();
        map.put("Context", "LoginBySms");
        map.put("AppId", AuthInfo.getAppId());
        map.put("Uid", userPhoneNumber);
        map.put("ServiceName", "UdbApp.LoginServer.LoginObj");
        map.put("FunctionName", "LoginBySms");
        map.put("ProtoType", "http");
//        map.put("InstId", "LoginBySms");
//        map.put("ServerId", "LoginBySms");
        tag = fun;
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);
        ALog.i(fun + "userPhoneNumber:" + userPhoneNumber + ", otp: " + (otp == null ? "" : otp));
        executeInner(path, map, smsLoginReq.toByteArray(), timeout);
    }

    private String getEventType() {
        return compose(EventTypeUtils.smsLogin);
    }

    private void reportNext(int errType, int errCode, String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

//            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }
    }

    private void onSmdLoginFailed(long bTime, final int errType, final int errCode,
                                  final String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

//            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    @Override
    public void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onNext(requestId, authCode, authDesc, dynVerify, this);
//        }
//        callback = null;
//        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onSuccess(Call call, byte[] data, int httpCode, long useTime) {
        SmsLoginRsp res;
        try {
            res = SmsLoginRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            String msg = e.getMessage();
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "IOException, err:" + msg + ", code: " + httpCode;
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpCode, CodeUtils.smsLogin);
            onSmdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code, msg);
            return;
        }

        ALog.i(fun + "success,phoNo=" + userPhoneNumber + ",authSrvCode:" + res.getErrcode() +
                ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();

            if (bTime > 0) {
                CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                report.mRtt = eTime - bTime;
                report.mEventType = getEventType();
                report.mSucceed = 0;
                report.mErrType = 0;
                report.mErrCode = 0;
                report.mTraceId = traceId;
                report.mChannel = ChannelName.HTTP;
                report.mUserInfo = userPhoneNumber;

                report.mQuicResult = quicResult;
                report.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(report);
                CHidoReport.getInstance().report2Metric(report);
            }
            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            //单位s
            info.mTS = res.getServerTime();
            info.mIsNewUser = res.getIsnewuser() == 1 ? true : false;
            info.mUrl = res.getUrl();
            info.extjsstr = res.getExtjsstr();
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else if (res.getErrcode() == Errcode.NEXT_VER) {
            //需要二次验证
            ALog.e(fun + "需要二次验证");
            final SmsLoginRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
                            otp, callback, runnable);
//                    if (callback.count == 1) {
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    } else if (callback.count > 1) {
//                        if (callback.isSuccess()) {
//                            return;
//                        }
//                        callback.setSuccess(true);
//                        if (callback.isNext()) {
//                            return;
//                        }
//                        callback.setNext(true);
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    }
                }
            });
        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
            //二次验证码失败
            final SmsLoginRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            if (TextUtils.isEmpty(nextVerify.mDynVer)) {
                ALog.e(fun + "二次验证码失败");
            } else {
                ALog.e(fun + "二次验证码失败，需要再次验证");
            }
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
                            otp, callback, runnable);
//                    if (callback.count == 1) {
//
//                    } else if (callback.count > 1) {
//                        if (callback.isSuccess()) {
//                            return;
//                        }
//                        callback.setSuccess(true);
//                        if (callback.isNext()) {
//                            return;
//                        }
//                        callback.setNext(true);
//                        NextVerifyUtils.smsLogin(context, 0, resp, userPhoneNumber, smsCode,
//                                otp, callback.getCallback(), runnable);
//                    }
//                    onNext(0, errCode, errDescription, nextVerify);
                }
            });
        } else {
            AuthCore.setSessionData(res.getSessiondata());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onSmdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }

    @Override
    public void onFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.AUTH_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.smsLogin);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onSmdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.CONNECT_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.smsLogin);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onSmdLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }
}
