package com.yy.platform.loginlite;

import android.content.Context;

import com.dw.android.itna.DwItna;
import com.google.protobuf.ByteString;
import com.yy.platform.loginlite.proto.AntiGetPcid;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeReqHw;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeRspHw;
import com.yy.platform.loginlite.utils.ServiceUrls;

import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;

/**
 * 风控模块
 * @author ruilin
 * 2020/11/2
 */
public class RiskManager {
    private static final String SERVER_NAME_ANTI = "svc_anti_codegetverify_service_hw";
    private static final String FUN_NAME_ANTI = "AntiGetSdkCodeReqHw";
    private static final String SERVER_NAME_PCID = "svc_anti_pcid_service_hw";
    private static final String FUN_NAME_PCID = "AntiGetPcidReqHw";

    private static final int TIMEOUT = 10 * 1000;
    private static final int count = 3;
    private final String mAppId;
    private Context mAppContext;
    private volatile String mPcid = null;    // 缓存pcid，以提高性能
    private OnPcidChangedListener mPcidListener;

    public interface OnPcidChangedListener {
        void onPcidChanged(String pcid);
    }

    public RiskManager(Context context, final String appId) {
        mAppId = appId;
        mAppContext = context.getApplicationContext();
    }

    public void setOnPcidChangedListener(OnPcidChangedListener l) {
        mPcidListener = l;
    }

    /**
     * 运行反外挂脚本
     * @param code 脚本
     * @param anonymous 是否匿名
     */
    public byte[] runAntiCode(byte[] code, int anonymous) {
        return DwItna.exec(mAppContext, code, mAppId, anonymous);
    }

    /**
     * 获取缓存的PCID
     * @return 内部异常时反回null
     */
    @Nullable
    public String getPcid() {
        if (mPcid == null) {
            mPcid = AntiHelper.getPcidDecode(mAppContext);
        }
        return mPcid;
    }

    /**
     * 采集设备信息并连接服务器同步PCID
     * @param bizName
     */
    public void syncPcid(String bizName) {
        doAntiCodeRequest(0, bizName);
    }

    /**
     * 请求anti code
     * @param yyuid
     * @return
     */
    private int doAntiCodeRequest(final long yyuid, String bizName) {
//        String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            ALog.i("no anti_hw bizName for check anticode");
            return -1;
        }
        final AntiGetSdkCodeReqHw req = AntiGetSdkCodeReqHw.newBuilder()
                .setBizName(bizName)
                .setUid(yyuid)
                .setIp(0)
                .build();
        final String serverName = SERVER_NAME_ANTI;
        final String funcName = FUN_NAME_ANTI;

        AntiHelper.getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < count; i++) {
                    final String traceId = UUID.randomUUID().toString();
                    HttpURLConnection conn = null;
                    final String url = ServiceUrls.getHttpUrl() + serverName + "/" + funcName;
                    ALog.i("<Anti> yyuid:" + yyuid + ", traceId: " + traceId + ", url: " + url);
                    try {
                        URL httpURL = new URL(url);
                        conn = (HttpURLConnection) httpURL.openConnection();
                        conn.setRequestMethod(ServiceUrls.POST);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setConnectTimeout(TIMEOUT);
                        conn.setReadTimeout(TIMEOUT);

                        conn.addRequestProperty("Context", funcName);
                        conn.addRequestProperty("AppId", AuthInfo.getAppId());
                        conn.addRequestProperty("Uid", String.valueOf(yyuid));
                        conn.addRequestProperty("ServiceName", serverName);
                        conn.addRequestProperty("FunctionName", funcName);
                        conn.addRequestProperty("TraceId", traceId);
                        conn.addRequestProperty("ProtoType", "http");
                        conn.addRequestProperty("InstId", funcName);
                        conn.addRequestProperty("ServerId", funcName);

                        OutputStream os = conn.getOutputStream();
                        req.writeTo(os);
                        conn.connect();

                        int code = conn.getResponseCode();
                        ALog.i("<Anti> http:" + code);
                        AntiGetSdkCodeRspHw res = AntiGetSdkCodeRspHw.newBuilder().
                                mergeFrom(conn.getInputStream()).build();
                        if (res != null) {
                            ALog.i("<Anti> response success");
                            //执行反外挂码
                            ByteString codeByte = res.getCode();
//                            runAntiCodeHwHttp(res.getUid(),
//                                    codeByte == null ? "".getBytes() : codeByte.toByteArray());
                            doAntiTask(res.getUid(),
                                    codeByte == null ? "".getBytes() : codeByte.toByteArray());
                            break;
                        } else {
                            ALog.i("<Anti> response fail");
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        String errInfo = "<Anti> connect exception, " + e.getMessage();
                        ALog.i(errInfo);
                    } finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }
        });
        return 1;
    }

    /**
     * 执行反外挂和上报
     * @param yyuid
     * @param code
     */
    private void doAntiTask(final long yyuid, final byte[] code) {
        final String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            ALog.i("<Anti> no anti bizName for run anticodeHw");
            return;
        }
        AntiHelper.getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                DwItna.setUdbId(AuthInfo.getHeader().getDeviceId());
                byte[] execCode = DwItna.exec(AuthInfo.getAppContext(),
                        code == null ? "".getBytes() : code,
                        AuthInfo.getAppId(), 0);
                AntiGetPcid.AntiGetPcidProxyHwRequest req = AntiGetPcid.AntiGetPcidProxyHwRequest.newBuilder()
                        .setBizName(bizName)
                        .setUid(yyuid)
                        .setSdkData(ByteString.copyFrom(execCode == null ? "".getBytes() : execCode))
                        .setIp(0)
                        .setScene("1")
                        .build();

                for (int i = 0; i < count; i++) {
                    final String traceId = UUID.randomUUID().toString();
                    HttpURLConnection conn = null;
                    final String url = ServiceUrls.getHttpUrl() + SERVER_NAME_PCID + "/" + FUN_NAME_PCID;
//                    final String url = "http://118.191.192.167:8090/" + SERVER_NAME_PCID + "/" + FUN_NAME_PCID;

                    ALog.i("<Anti> AntiGetPcidProxyHwResponse yyuid:" + yyuid + ", traceId: " + traceId + ", url: " + url);
                    try {
                        URL httpURL = new URL(url);
                        conn = (HttpURLConnection) httpURL.openConnection();
                        conn.setRequestMethod(ServiceUrls.POST);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setConnectTimeout(TIMEOUT);
                        conn.setReadTimeout(TIMEOUT);

                        conn.addRequestProperty("Context", FUN_NAME_PCID);
                        conn.addRequestProperty("AppId", AuthInfo.getAppId());
                        conn.addRequestProperty("Uid", String.valueOf(yyuid));
                        conn.addRequestProperty("ServiceName", SERVER_NAME_PCID);
                        conn.addRequestProperty("FunctionName", FUN_NAME_PCID);
                        conn.addRequestProperty("TraceId", traceId);
                        // conn.addRequestProperty("Content-Type", "application/yyrpc-pb");
                        conn.addRequestProperty("ProtoType", "http");
                        conn.addRequestProperty("InstId", FUN_NAME_PCID);
                        conn.addRequestProperty("ServerId", FUN_NAME_PCID);

                        OutputStream os = conn.getOutputStream();
                        req.writeTo(os);
                        conn.connect();

                        int code = conn.getResponseCode();
                        ALog.i("<Anti> AntiGetPcidProxyHwResponse code:" + code);
                        // 反外挂结果上报 Http响应

                        AntiGetPcid.AntiGetPcidProxyHwResponse res = AntiGetPcid.AntiGetPcidProxyHwResponse.newBuilder()
                                .mergeFrom(conn.getInputStream()).build();
                        if (res != null) {
                            ALog.i("<Anti> AntiGetPcidProxyHwResponse Success size" + res.getPcid().size());
                            updatePcid(res.getPcid());
                            break;
                        } else {
                            ALog.i("<Anti> AntiGetPcidProxyHwResponse Fail ");
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        ALog.i("<Anti> AntiGetPcidProxyHwResponse exception:" + e.getMessage());
                    } finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }

            }
        });
    }

    private void updatePcid(ByteString code) {
        try {
            DwItna.exec(mAppContext, code.toByteArray());
            mPcid = getPcid();
            if (mPcidListener != null)
                mPcidListener.onPcidChanged(mPcid);
        } catch (Exception e) {
            ALog.i("<Anti> updatePcid() error!!");
            e.printStackTrace();
        }
    }
}
