package com.yy.platform.loginlite;

import android.content.SharedPreferences;

public class NetworkStrategy {

    private volatile static NetworkStrategy instance;
    private SharedPreferences preferences;
    private volatile int isQuicStatus = 0;
    private volatile int isHttpStatus = 0;
    private volatile long quicTime = 0;
    private volatile long httpTime = 0;

    public static final String KEY_SUM = "network_sum";
    public static final String KEY_RESULT = "network_result";
    public static final String KEY_TIME = "now";
    private static final long MONTH = 30 * 24 * 3600;
    private static final long count = 3;

    private NetworkStrategy() {

    }

    public static NetworkStrategy getInstance() {
        if (instance == null) {
            synchronized (NetworkStrategy.class) {
                if (instance == null) {
                    instance = new NetworkStrategy();
                }
            }
        }
        return instance;
    }

    public void setPreferences(SharedPreferences pref) {
        this.preferences = pref;
    }

    public void setHttpStatus(boolean flag) {
        this.isHttpStatus = flag ? 1 : -1;
        evaluate();
    }

    public void setHttpTime(long time) {
        this.httpTime = time;
        evaluate();
    }

    public void setQuicStatus(boolean flag) {
        this.isQuicStatus = flag ? 1 : -1;
        evaluate();
    }

    public void setQuicTime(long time) {
        this.quicTime = time;
        evaluate();
    }

    private synchronized void evaluate() {
        if (isQuicStatus != 0 && isHttpStatus != 0 && quicTime != 0 && httpTime != 0) {
            ALog.e("start evaluate... quic=" + isQuicStatus + ", http=" + isHttpStatus +
                    ", quic time=" + quicTime + ", http time=" + httpTime);
            int value;
            if (isHttpStatus == 1 && isQuicStatus == 1) {
                if (quicTime > httpTime) {
                    ALog.e("choice http");
                    value = 1;
                } else {
                    ALog.e("choice quic");
                    value = -1;
                }
            } else if (isHttpStatus == 1 && isQuicStatus == -1) {
                ALog.e("choice http");
                value = 1;
            } else if (isHttpStatus == -1 && isQuicStatus == 1) {
                ALog.e("choice quic");
                value = -1;
            } else {
                ALog.e("choice http");
                value = 1;
            }

            if (preferences != null) {
                int sum = preferences.getInt(KEY_SUM, 0);
                if (sum == count) {
                    return;
                }
                int result = preferences.getInt(KEY_RESULT, 0);
                int newResult = result + value;
                int newSum = sum + 1;

                ALog.e("old sum=" + sum + ",value=" + result +
                        ", new sum=" + newSum + ",value=" + newResult);
                SharedPreferences.Editor edit = preferences.edit();
                if (newSum == count) {
                    edit.putLong(KEY_TIME, System.currentTimeMillis());
                }
                edit.putInt(KEY_SUM, newSum);
                edit.putInt(KEY_RESULT, newResult);
                edit.commit();
            }
            reset();
        }
    }

    public int[] getResult() {
        if (preferences != null) {
            int result = preferences.getInt(KEY_RESULT, 0);
            int sum = preferences.getInt(KEY_SUM, 0);
            return new int[]{sum, result};
        } else {
            return new int[]{0, 0};
        }
    }

    public long getTime() {
        if (preferences != null) {
            return preferences.getLong(KEY_TIME, 0);
        } else {
            return 0;
        }
    }

    public boolean[] choiceStrategy() {
        int[] result = getResult();
        long time = getTime();
        long duration = System.currentTimeMillis() - time;
        ALog.e("credit sum=" + result[0] + " value=" + result[1] + " " + time);
        if (time > 0 && duration / 1000 >= MONTH) {
            clear();
        }
        boolean isUseHttp = true;
        boolean isUseQuic = true;
        if (result[0] == count) {
            if (result[1] > 0) {
                isUseQuic = false;
            } else if (result[1] < 0) {
                isUseHttp = false;
            }
        }
        return new boolean[]{isUseHttp, isUseQuic};
    }

    public void clear() {
        if (preferences != null) {
            SharedPreferences.Editor edit = preferences.edit();
            edit.putLong(KEY_TIME, 0);
            edit.putInt(KEY_RESULT, 0);
            edit.putInt(KEY_SUM, 0);
            edit.commit();
        }
    }

    private void reset() {
        isQuicStatus = 0;
        isHttpStatus = 0;
        quicTime = 0;
        httpTime = 0;
    }
}
