package com.yy.platform.loginlite;

/**
 * Created by chenkaicai on 2018/7/16.
 */

public interface ISmsRegisterCallback {
    /**
     *
     * @param requestId
     *          上下文ID，用于异步处理
     * @param uinfo
     *          注册成功后的账号
     */
    void onSuccess(int requestId, YYInfo uinfo);

    /**
     *  短信登录失败
     * @param requestId
     *          上下文ID，用于异步处理
     * @param codeType
     *          错误类型，{@link com.yy.platform.loginlite.ResCodeDef.Type}
     * @param resCode
     *          错误码，依codeType不同而不同，请看codeType的定义取值
     * @param resDesc
     *          相应错误码的描述
     *          如果codeType为{@link ResCodeDef.Type#AUTH_SRV_REGISTER_CODE}
     *          则resDesc为错误提示文案，用于直接在ui显示。可能包含超链接内容。
     */
    void onFail(int requestId, int codeType, int resCode, String resDesc);
}
