package com.yy.platform.loginlite;


public interface IQrConfirmCallback {
    /**
     * 确认扫码授权成功
     * @param requestId
     *          上下文ID，用于异步处理
     */
    void onSuccess(int requestId);

    /**
     * 动态验证，需二次验证
     * @param requestId】
     *          上下文ID，用于异步处理
     * @param dynVerify
     *          动态验证的H5 url和SessionData
     */
    void onNext(int requestId, NextVerify dynVerify);

    /**
     *  确认扫码授权失败
     * @param requestId
     *          上下文ID，用于异步处理
     * @param codeType
     *          错误类型，{@link com.yy.platform.loginlite.ResCodeDef.Type}
     * @param resCode
     *          错误码，依codeType不同而不同，请看codeType的定义取值
     * @param resDesc
     *          相应错误码的描述
     *          如果codeType为{@link ResCodeDef.Type#AUTH_SRV_CODE}
     *          则resDesc为错误提示文案，用于直接在ui显示。可能包含超链接内容。
     */
    void onFail(int requestId, int codeType, int resCode, String resDesc);
}
