package com.yy.platform.loginlite;

import java.util.Map;

/**
 * Created by chenkaicai on 2018/10/24.
 */

public interface ILoginliteListener {

    interface ILoginliteHiidoMetricsStatisApi {
        /**
         * 对应 HiidoSDK.instance().reportReturnCode
         *
         * @param scode
         * @param uri
         * @param timeConsumption
         * @param code
         */
        void reportReturnCode(final int scode, final String uri, final long timeConsumption, final String code);

        /**
         * 对应 HiidoSDK.instance().reportCount
         *
         * @param scode
         * @param uri
         * @param countName
         * @param count
         */
        void reportCount(int scode, String uri, String countName, long count);

        /**
         * 对应 HiidoSDK.instance().reportCount
         *
         * @param scode
         * @param uri
         * @param countName
         * @param count
         * @param times
         */
        void reportCount(int scode, String uri, String countName, long count, int times);

        /**
         * 对应 HiidoSDK.instance().reportStatisticContentTemporary
         *
         * @param act
         * @param intFields
         * @param longFields
         * @param stringFields
         */
        void reportStatisticContentTemporary(String act,
                                             Map<String, Integer> intFields,
                                             Map<String, Long> longFields,
                                             Map<String, String> stringFields);
    }
}
