package com.yy.platform.loginlite;


public interface IGuestLoginCallback {
    /**
     * 游客登录成功
     *
     * @param requestId 上下文ID，用于异步处理
     * @param uinfo     登录成功后的账号
     */
    void onSuccess(int requestId, YYInfo uinfo);

    /**
     * 需要二次验证
     *
     * @param requestId 上下文ID，用于异步处理
     * @param authCode  返回码，目前有2种code：
     *                  1）NEXT_VER = 1;需要二次验证
     *                  2）VCODE_ERR = 13;二次验证码错误，用新的url重新输验证码验证
     * @param dynVerify 动态验证的H5 url
     */
    void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify);

    /**
     * 游客登录失败
     *
     * @param requestId 上下文ID，用于异步处理
     * @param codeType  错误类型，{@link com.yy.platform.loginlite.ResCodeDef.Type}
     * @param resCode   错误码，依codeType不同而不同，请看codeType的定义取值
     * @param resDesc   相应错误码的描述
     *                  如果codeType为{@link ResCodeDef.Type#AUTH_SRV_CODE}
     *                  则resDesc为错误提示文案，用于直接在ui显示。可能包含超链接内容。
     */
    void onFail(int requestId, int codeType, int resCode, String resDesc);
}
