package com.yy.platform.loginlite;

import java.util.Map;

public interface IAuthCore {

    /**
     * HiidoSDK由APP层引入，设置接收统计数据的回调
     *
     * @param listener
     */
    void setHiidoMetricsApi(ILoginliteListener.ILoginliteHiidoMetricsStatisApi listener);

    /**
     * 设置quic请求代理
     *
     * @param handler
     */
    void setQuicHandler(IQuicHandler handler);

    /**
     * 请求短信验证码
     *
     * @param phone    手机号码，加上区码前缀：中国 0086 印尼 0062 美国 001
     * @param smsType  短信类型，0：文本短信，1：语音短信。默认0
     * @param smsLength       短信的长度，"4"：4位长度，"6"：6位长度，填""：6位长度
     * @param dynCode  *   二次验证的验证码，首次请求或者没有启用二次验证策略的则给""
     * @param whatsappToken whatsapp的token
     * @param callback *   请求的回执，成功则会收到手机短信或提示需要二次验证
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int getSms(String phone, String smsType, String smsLength, String dynCode,
               String whatsappToken, IGetSmsCallback callback);

    /**
     * 短信验证码注册
     *
     * @param account  手机号码，加上区码前缀：中国 0086 印尼 0062 美国 001
     * @param smsCode  短信验证码
     * @param password 密码
     * @param callback 登录结果回调
     * @return 0 发送请求成功，-1 传入参数错误导致请求未发送
     */
    // int smsRegister(String account, String smsCode, String password, ISmsRegisterCallback callback);

    /**
     * 短信验证码登录
     *
     * @param userPhoneNumber 手机号码，加上区码前缀：中国 0086 印尼 0062 美国 001
     * @param smsCode         短信验证码
     * @param dynCode         二次验证的验证码，首次请求或者没有启用二次验证策略的则给""
     * @param otp             游客登录后的otp，可以为""
     * @param callback        登录结果回调
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int smsLogin(String userPhoneNumber, String smsCode, String dynCode, String otp, ISmsLoginCallback callback);

    /**
     * 短信验证码登录
     *
     * @param userPhoneNumber 手机号码，加上区码前缀：中国 0086 印尼 0062 美国 001
     * @param smsCode         短信验证码
     * @param dynCode         二次验证的验证码，首次请求或者没有启用二次验证策略的则给""
     * @param callback        登录结果回调
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int smsLogin(String userPhoneNumber, String smsCode, String dynCode, ISmsLoginCallback callback);

    /**
     * 短信改密
     *
     * @param userPhoneNumber 手机号码，加上区码前缀：中国 0086 印尼 0062 美国 001
     * @param smsCode         短信验证码
     * @param password        新密码
     * @param callback        登录结果回调
     * @return 本次请求的taskID
     */
    //int smsModifyPwd(String userPhoneNumber, String smsCode, String password, ISmsModifyPwdCallback callback);

    /**
     * 账号密码登录
     *
     * @param account  帐号
     * @param password 密码
     * @param dynCode  *   二次验证的验证码，首次请求或者没有启用二次验证策略的则给""
     * @param callback 登录结果回调
     * @return 本次请求的taskID
     */
//    int passwordLogin(String account, String password, String dynCode, IPasswordLoginCallback callback);

    /**
     * 凭证登录，前一次登录成功后app可以保留凭证用作下一次调用本接口自动登录
     *
     * @param yyuid    帐号UID
     * @param stoken   hago传入stoken
     * @param callback 登录回调
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int creditLogin(long yyuid, String stoken, ICreditLoginCallback callback);

    /**
     * 第三方登录
     *
     * @param channel   渠道，取如下值之一:
     *                  {facebook,google,twitter,instagram,weibo,qq,wechat}
     * @param token     从第三方得到的code 或者 accesstoken
     * @param tokenType token为第三方的code时给0，为accesstoken时给1
     * @param openid    第三方的UserId等，非必填，如果有就填上，没有就给""
     * @param authUrl   在第三方注册app时填的鉴权回调url，非必填，如果有就填上，没有就给""
     * @param extInfo   (预留参数)扩展信息参数，json格式，非必填，没有就给""
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int thirdLogin(String channel, String token, int tokenType, String openid, String authUrl, String extInfo,
                   IThirdLoginCallback callback);

    /**
     * 第三方登录，扩展携带一些Headers信息到后端
     *
     * @param channel   渠道，取如下值之一:
     *                  {facebook,google,twitter,instagram,weibo,qq,wechat}
     * @param token     从第三方得到的code 或者 accesstoken
     * @param tokenType token为第三方的code时给0，为accesstoken时给1
     * @param openid    第三方的UserId等，非必填，如果有就填上，没有就给""
     * @param authUrl   在第三方注册app时填的鉴权回调url，非必填，如果有就填上，没有就给""
     * @param extInfo   (预留参数)扩展信息参数，json格式，非必填，没有就给""
     * @param headers   携带透传一些字段到后端业务，约束：key须以大写字母开头(quic通道时后端会转换)
     * @param callback
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int thirdLogin(String channel, String token, int tokenType, String openid, String authUrl, String extInfo,
                   Map<String, String> headers, IThirdLoginCallback callback);

    /**
     * 获取目标appId的OTP用于登录等
     *
     * @param destAppId 目标业务AppId，取本App的UDB登录token 给空即可
     * @return
     */
    byte[] getOtp(String destAppId, long uid);

    /**
     * 获取bind Service 的Token
     *
     * @return
     */
    byte[] getServiceToken(long uid);

    /**
     * 退出当前登录的UID，退出后所有OTP失效，如有需要则重新登录
     * 注意调用此接口后也需要调用ServiceSDK的unBind，保证登录相关的逻辑正确
     *
     * @param enableAutoLoginNext
     * 是否允许下次可以进行creditLogin 自动登录，
     * 此参数给false，则下次登录必须要用手机号或者密码重登了，所以大多数情况此参数要给true
     */
    void logout(boolean enableAutoLoginNext);

    /***
     * 扫码授权
     * @param yyuid
     *          帐号,uid
     * @param qrId
     *          二维码id，扫码后从二维码图片中获取qrcode_id
     * @param callback
     *          回调
     * @return
     */
//    int qrScan(long yyuid, String qrId, IQrScanCallback callback);

    /**
     * 点击确认，授权显码方登录
     *
     * @param yyuid    帐号,uid
     * @param qrId     二维码id，扫码后从二维码图片中获取qrcode_id
     * @param callback 回调
     * @return
     */
//    int qrAuthConfirm(long yyuid, String qrId, IQrConfirmCallback callback);

    /**
     * 点击取消，取消授权登录
     *
     * @param yyuid    帐号,uid
     * @param qrId     二维码id，扫码后从二维码图片中获取qrcode_id
     * @param callback 回调
     * @return
     */
//    int qrAuthCancel(long yyuid, String qrId, IQrCancelCallback callback);

    /**
     * 第三方登录后绑定手机号
     *
     * @param phoNum   手机号码
     * @param uid      UID
     * @param smsCode  短信验证码
     * @param callback 手机绑定回调
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int bindMobilePhone(String phoNum, long uid, String smsCode, IBindMobilePhoneCallback callback);

    /**
     * 绑定第三方token
     *
     * @param channel   渠道，取如下值之一:
     *                  {facebook,google,twitter,instagram,weibo,qq,wechat}
     * @param token     从第三方得到的code 或者 accesstoken
     * @param tokenType token为第三方的code时给0，为accesstoken时给1
     * @param openid    第三方的UserId等，非必填，如果有就填上，没有就给""
     * @param uid       用户id
     * @param optToken  token
     * @param authUrl   在第三方注册app时填的鉴权回调url，非必填，如果有就填上，没有就给""
     * @param extInfo   (预留参数)扩展信息参数，json格式，非必填，没有就给""
     * @param callback
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int bindThirdToken(String channel, String token, int tokenType, String openid, String uid, String optToken,
                       String authUrl, String extInfo, IThirdLoginCallback callback);


    /**
     * 游客登录
     *
     * @param dynCode  二次验证的验证码，首次请求或者没有启用二次验证策略的则给""
     * @param callback
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int guestLogin(String dynCode, IGuestLoginCallback callback);

    String getLogTag();

    /**
     * @param url      查询第三方openid/unionid接口
     * @param appid    业务appid
     * @param uid      用户uid
     * @param otp      otp票据
     * @param callback 请求成功返回JSON格式数据
     *                 rescode: 查询结果码，0 代表成功，-6 代表otp验证不通过，-9 代表不存在openid,
     *                 其他返回码 查询失败
     *                 resmsg: 查询结果码描述
     *                 data: openid数据列表，当rescode=0有值，JSON格式：
     *                 channel:第三方渠道
     *                 openid: 用户openid(qq、微信用户是unionid)
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int findOpenId(String url, long appid, long uid, byte[] otp, IFindOpenIdCallback callback);

    /**
     * 获取whatsapp的token
     *
     * @param context  预留字段，上下文用于异步化处理
     * @param callbcak
     * @return 0 发送请求成功，小于0 传入参数错误导致请求未发送
     */
    int getWhatsappToken(String context, IGetWhatsappTokenCallback callbcak);

    /**
     * 获取风控模块
     * @return
     */
    RiskManager getRisk();

    void cancel();
}
