//package com.yy.platform.loginlite;
//
//import com.yy.platform.loginlite.proto.Errcode;
//import com.yy.platform.loginlite.proto.GuestLoginReq;
//import com.yy.platform.loginlite.proto.GuestLoginRsp;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//import com.yy.platform.loginlite.utils.UserInfoUtils;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/10.
// */
//
//public class GuestLoginQuic implements IGuestLoginCallback {
//    private IGuestLoginCallback callback;
//    private long startTime;
//    private boolean isTimeout = false;
//    private Lock callbackLock;
//    private IQuicHandler quicHttp = null;
//    private String dynCode;
//    private String traceId;
//    private static final String fun = "GuestLogin using quic ";
//
//    public GuestLoginQuic(IQuicHandler handler, long sTime, String dynCode, IGuestLoginCallback callback) {
//        this.quicHttp = handler;
//        this.dynCode = dynCode;
//        this.callback = callback;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int run() {
//        long bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        GuestLoginReq guestLoginReq = GuestLoginReq.newBuilder()
//                .setDynCode(dynCode == null ? "" : dynCode)
//                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getQuitUrl() + "UdbApp.LoginServer.LoginObj/LoginByGuest";
//        ALog.i(fun + "traceId: " + traceId + ", url: " + url);
//
//        quicHttp.init();
//        HashMap<String, String> header = new HashMap<>();
//
//        header.put("Context", "LoginByGuest");
//        header.put("AppId", AuthInfo.getAppId());
//        header.put("ServiceName", "UdbApp.LoginServer.LoginObj");
//        header.put("FunctionName", "LoginByGuest");
//        header.put("TraceId", traceId);
//        header.put("ProtoType", "Quic");
//        header.put("InstId", "LoginByGuest");
//        header.put("ServerId", "LoginByGuest");
//
//        try {
//            quicHttp.connect(url, "POST", header, guestLoginReq.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            String errInfo = fun + "connect exception, " + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            String errInfo = fun + "getResponseCode exception, " + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//        }
//
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            String errInfo = fun + "recvResponse code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    quicHttp.getResponseCode(), errInfo, callback);
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//
//            String errInfo = fun + "connect err code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onSmdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo, callback);
//            return quicResult;
//        }
//
//        GuestLoginRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = GuestLoginRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//        ALog.i(fun + "success," + ",authSrvCode:" + res.getErrcode() +
//                ", authSrvDesc:" + res.getDescription());
//
//        if (res.getErrcode() == Errcode.SUCCESS) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = eTime - bTime;
//                response.mEventType = "LoginByGuest/quic";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//                response.mUserInfo = AuthInfo.getHeader().getDeviceId();
//
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
//                CHidoReport.getInstance().report2Hido(response);
//                CHidoReport.getInstance().report2Metric(response);
//            }
//
//            final YYInfo info = new YYInfo();
//            UserInfoUtils.unPack(res.getUserData(), info);
//            //单位s
//            info.mTS = res.getServerTime();
//            info.mIsNewUser = res.getIsnewuser() == 1 ? true : false;
//            info.mUrl = res.getUrl();
//            info.extjsstr = res.getExtjsstr();
//
//            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onSuccess(0, info);
//                    AntiHelper.checkAntiCodeHw(info.mUid);
//                }
//            });
//        } else if (res.getErrcode() == Errcode.NEXT_VER) {
//            //需要二次验证
//            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
//            final NextVerify nextVerify = new NextVerify();
//            nextVerify.mDynVer = res.getDynVer();
//            AuthCore.setSessionData(res.getSessiondata());
//            final int errCode = res.getErrcodeValue();
//            final String errDescription = res.getDescription();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onNext(0, errCode, errDescription, nextVerify);
//                }
//            });
//        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
//            //二次验证码失败
//            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
//            final NextVerify nextVerify = new NextVerify();
//            nextVerify.mDynVer = res.getDynVer();
//            AuthCore.setSessionData(res.getSessiondata());
//            final int errCode = res.getErrcodeValue();
//            final String errDescription = res.getDescription();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onNext(0, errCode, errDescription, nextVerify);
//                }
//            });
//        } else {
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
//                    res.getErrcodeValue(), res.getDescription());
//        }
//
//        return quicResult;
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onGuestLoginFailed(long bTime, final int errType, final int errCode,
//                                   final String description) {
//        long eTime = System.currentTimeMillis();
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "LoginByGuest/quic";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = AuthInfo.getHeader().getDeviceId();
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//    }
//
//
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//
//    @Override
//    public void onSuccess(int requestId, YYInfo uinfo) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId, uinfo);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onNext(requestId, authCode, authDesc, dynVerify);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
