package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.GuestLoginReq;
import com.yy.platform.loginlite.proto.GuestLoginRsp;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class GuestLoginHttp extends BaseHttp implements IGuestLoginCallback {
    private IGuestLoginCallback callback;
    private String dynCode;
    private long startTime;
    private boolean isTimeout = false;
    private Lock callbackLock;
    private static final String fun = "GuestLogin using http ";
    private long bTime;
    private String traceId;
    private GuestLoginReq guestLoginReq;
    private String url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginByGuest";

    public GuestLoginHttp(long sTime, String dynCode, IGuestLoginCallback callback) {
        super(callback);
        this.callback = callback;
        this.dynCode = dynCode;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;
        guestLoginReq = GuestLoginReq.newBuilder()
                .setDynCode(dynCode == null ? "" : dynCode)
                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
                .setPrheader(AuthInfo.getHeader())
                .build();
    }

    public int execute() {
        bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);
        traceId = UUID.randomUUID().toString();
        ALog.i(fun + " traceId: " + traceId + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "LoginByGuest");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("ServiceName", "UdbApp.LoginServer.LoginObj");
            conn.addRequestProperty("FunctionName", "LoginByGuest");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
            conn.addRequestProperty("InstId", "LoginByGuest");
            conn.addRequestProperty("ServerId", "LoginByGuest");

            OutputStream os = conn.getOutputStream();
            guestLoginReq.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
                if (conn != null) {
                    conn.disconnect();
                }
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            ALog.i(fun + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
            return quicResult;
        }


        GuestLoginRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = GuestLoginRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(fun + "getInputStream IOException, errInfo:" + e.getMessage());
            onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        ALog.i(fun + "success," + ",authSrvCode:" + res.getErrcode() +
                ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "LoginByGuest/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = AuthInfo.getHeader().getDeviceId();

                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }

            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            //单位s
            info.mTS = res.getServerTime();
            info.mIsNewUser = res.getIsnewuser() == 1 ? true : false;
            info.mUrl = res.getUrl();
            info.extjsstr = res.getExtjsstr();
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else if (res.getErrcode() == Errcode.NEXT_VER) {
            //需要二次验证
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onNext(0, errCode, errDescription, nextVerify);
                }
            });
        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
            //二次验证码失败
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onNext(0, errCode, errDescription, nextVerify);
                }
            });
        } else {
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }

        return quicResult;
    }

    public void onGuestLoginFailed(long bTime, final int errType, final int errCode,
                                   final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "LoginByGuest/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = AuthInfo.getHeader().getDeviceId();

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    @Override
    public void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, authCode, authDesc, dynVerify);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
