package com.yy.platform.loginlite;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.GuestLoginReq;
import com.yy.platform.loginlite.proto.GuestLoginRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/11.
 */

public class GuestLoginByOkhttp extends BaseOkHttp {

    private String path;
    private Map<String, String> map = new HashMap<String, String>();
    private long startTime;
    private Lock callbackLock;
    private GuestLoginReq guestLoginReq;

    private IGuestLoginCallback callback;
    private int timeout;
    private static final String fun = "GuestLogin ";
    private long bTime;
    private int httpResult;

    public GuestLoginByOkhttp(int timeout, long sTime, String dynCode, IGuestLoginCallback callback) {
        this.timeout = timeout;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        guestLoginReq = GuestLoginReq.newBuilder()
                .setDynCode(dynCode == null ? "" : dynCode)
                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
                .setPrheader(AuthInfo.getHeader())
                .build();

        path = "UdbApp.LoginServer.LoginObj/LoginByGuest";
        map.put("Context", "LoginByGuest");
        map.put("AppId", AuthInfo.getAppId());
        map.put("ServiceName", "UdbApp.LoginServer.LoginObj");
        map.put("FunctionName", "LoginByGuest");
        map.put("ProtoType", "http");
//        map.put("InstId", "LoginByGuest");
//        map.put("ServerId", "LoginByGuest");

        tag = fun;
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        executeInner(path, map, guestLoginReq.toByteArray(), timeout);
    }

    private String getEventType() {
        return compose(EventTypeUtils.guestLogin);
    }

    @Override
    public void onSuccess(Call call, byte[] data, int code, long useTime) {
        GuestLoginRsp res;
        try {
            res = GuestLoginRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            String msg = e.getMessage();
            httpResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "IOException, err:" + msg + ", code: " + code;
            ALog.i(errInfo);
            int httpCode = CodeUtils.makeCode(code, CodeUtils.guestLogin);
            onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, httpCode, msg);
            return;
        }

        ALog.i(fun + "success, authSrvCode:" + res.getErrcode() +
                ", authSrvDesc:" + res.getDescription());
        if (res.getErrcode() == Errcode.SUCCESS) {
            long eTime = System.currentTimeMillis();

            if (bTime > 0) {
                CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                report.mRtt = eTime - bTime;
                report.mEventType = getEventType();
                report.mSucceed = 0;
                report.mErrType = 0;
                report.mErrCode = 0;
                report.mTraceId = traceId;
                report.mChannel = ChannelName.HTTP;
                report.mUserInfo = AuthInfo.getHeader().getDeviceId();

//                report.mQuicResult = CHidoReport.QuicResult.SUCCESS;
                report.mTotalRtt = eTime - startTime;

                CHidoReport.getInstance().report2Hido(report);
                CHidoReport.getInstance().report2Metric(report);
            }
            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            //单位s
            info.mTS = res.getServerTime();
            info.mIsNewUser = false;
            info.mUrl = res.getUrl();
            info.extjsstr = res.getExtjsstr();
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);

            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else if (res.getErrcode() == Errcode.NEXT_VER) {
            //需要二次验证
            httpResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onNext(0, errCode, errDescription, nextVerify);
                }
            });
        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
            //二次验证码失败
            httpResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onNext(0, errCode, errDescription, nextVerify);
                }
            });
        } else {
            httpResult = (CHidoReport.QuicResult.AUTH_ERROR);
            onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }


    @Override
    public void onFail(int code, String message, long useTime) {
        httpResult = (CHidoReport.QuicResult.AUTH_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.guestLogin);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        httpResult = (CHidoReport.QuicResult.CONNECT_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.guestLogin);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onGuestLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    private void onGuestLoginFailed(long bTime, final int errType, final int errCode,
                                    final String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = AuthInfo.getHeader().getDeviceId();
//            response.mQuicResult = httpResult;
            response.mTotalRtt = eTime - startTime;

            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    private void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, authCode, authDesc, dynVerify);
        }
        callback = null;
        callbackLock.unlock();
    }

    private void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
