//package com.yy.platform.loginlite;
//
//import com.yy.platform.loginlite.proto.GetWhatsAppTokenReq;
//import com.yy.platform.loginlite.proto.GetWhatsAppTokenRsp;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/10.
// */
//
//public class GetWhatsappTokenQuic implements IGetWhatsappTokenCallback {
//
//    private boolean isTimeout = false;
//    private Lock callbackLock = null;
//    private static final String fun = "getWhatsappToken using quic ";
//    private String traceId = "";
//    private String context;
//    private IQuicHandler quicHttp;
//    private IGetWhatsappTokenCallback callback;
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//
//    public GetWhatsappTokenQuic(IQuicHandler handler, String context, IGetWhatsappTokenCallback callback) {
//        this.quicHttp = handler;
//        this.callback = callback;
//        this.context = context;
//        this.callbackLock = new ReentrantLock();
//    }
//
//    public int run() {
//        long bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        GetWhatsAppTokenReq req = GetWhatsAppTokenReq.newBuilder()
//                .setPrheader(AuthInfo.getHeader())
//                .setContext(context == null ? "" : context)
//                .build();
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginGetWhatsAppToken";
//        ALog.i(fun + "traceId: " + traceId + ", url: " + url);
//        quicHttp.init();
//        HashMap<String, String> quicHeader = new HashMap<>();
//        quicHeader.put("Context", "LoginGetWhatsAppToken");
//        quicHeader.put("AppId", AuthInfo.getAppId());
//        quicHeader.put("ServiceName", "UdbApp.LoginServer.LoginObj");
//        quicHeader.put("FunctionName", "LoginGetWhatsAppToken");
//        quicHeader.put("TraceId", traceId);
//        quicHeader.put("ProtoType", "Quic");
//        quicHeader.put("InstId", "LoginGetWhatsAppToken");
//        quicHeader.put("ServerId", "LoginGetWhatsAppToken");
//
//        try {
//            quicHttp.connect(url, "POST", quicHeader, req.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            ALog.i(fun + "connect exception, " + e.getMessage());
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            ALog.i(fun + "getResponseCode exception, " + e.getMessage());
//        }
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            ALog.i(fun + "recvResponse code:" + code);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            ALog.i(fun + "connect err code:" + code);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//            return quicResult;
//        }
//
//        GetWhatsAppTokenRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = GetWhatsAppTokenRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onGetWhatsappTokenFailed(code, e.getMessage());
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//
//        if (res.getErrcodeValue() == 0) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            ALog.i(fun + "success");
//            final String token = res.getWhatsapptoken();
//            final String context = res.getContext();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onSuccess(token, context);
//                }
//            });
//        } else {
//            ALog.i(fun + "fail  errCode:" + res.getErrcodeValue());
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onGetWhatsappTokenFailed(res.getErrcodeValue(), "");
//        }
//        return quicResult;
//    }
//
//    public void onGetWhatsappTokenFailed(final int errCode, final String errMsg) {
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(errCode, errMsg);
//            }
//        });
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    @Override
//    public void onSuccess(String token, String context) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(token, context);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int code, String errMsg) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(code, errMsg);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
