package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.GetWhatsAppTokenReq;
import com.yy.platform.loginlite.proto.GetWhatsAppTokenRsp;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class GetWhatsappTokenHttp implements IGetWhatsappTokenCallback {
    private static final String fun = "getWhatsappToken  ";
    private String traceId = "";
    private String context;

    public GetWhatsappTokenHttp(String context, IGetWhatsappTokenCallback callback) {
        this.callback = callback;
        this.context = context;
        this.callbackLock = new ReentrantLock();
    }

    public int run() {
        quicResult = (CHidoReport.QuicResult.ONGOING);

        GetWhatsAppTokenReq req = GetWhatsAppTokenReq.newBuilder()
                .setPrheader(AuthInfo.getHeader())
                .setContext(context == null ? "" : context)
                .build();

        traceId = UUID.randomUUID().toString();
        String url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginGetWhatsAppToken";
        ALog.i(fun + "traceId: " + traceId + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "LoginGetWhatsAppToken");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("ServiceName", "UdbApp.LoginServer.LoginObj");
            conn.addRequestProperty("FunctionName", "LoginGetWhatsAppToken");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
//            conn.addRequestProperty("InstId", "LoginGetWhatsAppToken");
//            conn.addRequestProperty("ServerId", "LoginGetWhatsAppToken");

            OutputStream os = conn.getOutputStream();
            req.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
                if (conn != null) {
                    conn.disconnect();
                }
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            ALog.i(fun + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
            return quicResult;
        }

        GetWhatsAppTokenRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = GetWhatsAppTokenRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onGetWhatsappTokenFailed(code, e.getMessage());
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        if (res.getErrcodeValue() == 0) {
            ALog.i(fun + "success");
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            final String token = res.getWhatsapptoken();
            final String context = res.getContext();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(token, context);
                }
            });
        } else {
            ALog.i(fun + "fail  errCode:" + res.getErrcodeValue());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onGetWhatsappTokenFailed(res.getErrcodeValue(), "");
        }
        return quicResult;
    }

    public void onGetWhatsappTokenFailed(final int errCode, final String errMsg) {
        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(errCode, errMsg);
            }
        });
    }

    IGetWhatsappTokenCallback callback;
    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    private Lock callbackLock;

    @Override
    public void onSuccess(String token, String context) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(token, context);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int code, String errMsg) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(code, errMsg);
        }
        callback = null;
        callbackLock.unlock();
    }
}
