//package com.yy.platform.loginlite;
//
//import android.content.Context;
//import android.text.TextUtils;
//
//import com.yy.platform.loginlite.proto.Errcode;
//import com.yy.platform.loginlite.proto.SendSmsReq;
//import com.yy.platform.loginlite.proto.SendSmsRsp;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/11.
// */
//
//public class GetSmsQuic implements IGetSmsCallback {
//
//    private String userPhoneNumber;
//    private String smsType;
//    private String smsLength;
//    private String dynCode;
//    private IGetSmsCallback callback;
//    private String traceId;
//    private IQuicHandler quicHttp;
//    private static final String fun = "GetSms using quic ";
//    private String token;
//
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//    private long startTime;
//    private boolean isTimeout = false;
//    private Lock callbackLock;
//    private long bTime;
//    private Context context;
//
//    public GetSmsQuic(
//            Context context,
//            IQuicHandler handler,
//            long sTime,
//            String userPhoneNumber,
//            String smsType,
//            String smsLength,
//            String dynCode,
//            String token,
//            IGetSmsCallback callback
//    ) {
//        this.context = context;
//        this.quicHttp = handler;
//        this.userPhoneNumber = userPhoneNumber;
//        this.smsType = smsType;
//        this.smsLength = smsLength;
//        this.dynCode = dynCode;
//        this.callback = callback;
//        this.token = token;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int run() {
//        bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        SendSmsReq smsReq = SendSmsReq.newBuilder()
//                .setUser(userPhoneNumber)
//                .setSmsType((smsType == null || smsType.isEmpty()) ? "0" : smsType)
//                .setPrheader(AuthInfo.getHeader())
//                .setCodelength((smsLength == null || smsLength.length() == 0) ? "6" : smsLength)
//                .setDynCode(dynCode == null ? "" : dynCode)
//                .putExtmap("whatsapptoken", token == null ? "" : token)
//                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
//                .build();
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getQuitUrl() + "UdbApp.LoginServer.LoginObj/LoginSendSms";
//        ALog.i(fun + " userPhoneNumber:" + userPhoneNumber
//                + ", smsType:" + smsType + ", smsLength:" + smsLength + ", traceId: " + traceId +
//                ", url: " + url);
//        if (!TextUtils.isEmpty(dynCode)) {
//            ALog.e(fun + "二次验证成功");
//        }
//
//        quicHttp.init();
//        HashMap<String, String> header = new HashMap<>();
//
//        header.put("Context", "LoginSendSms");
//        header.put("AppId", AuthInfo.getAppId());
//        header.put("Uid", userPhoneNumber);
//        header.put("ServiceName", "UdbApp.LoginServer.LoginObj");
//        header.put("FunctionName", "LoginSendSms");
//        header.put("TraceId", traceId);
//        header.put("ProtoType", "Quic");
//        header.put("InstId", "LoginSendSms");
//        header.put("ServerId", "LoginSendSms");
//
//        try {
//            quicHttp.connect(url, "POST", header, smsReq.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            String errInfo = fun + "connect exception, " + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onGetSmsFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            String errInfo = fun + "getResponseCode exception, " + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//        }
//
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            String errInfo = fun + "recvResponse code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onGetSmsFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    quicHttp.getResponseCode(), errInfo, callback);
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            String errInfo = fun + "connect err code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onGetSmsFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo, callback);
//            return quicResult;
//        }
//
//        SendSmsRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = SendSmsRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onGetSmsFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//        ALog.i(fun + "success,phoNo=" + userPhoneNumber +
//                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//
//        if (res.getErrcode() == Errcode.SUCCESS) {
//            boolean tmp = false;
//            if (res.getExtmapMap() != null) {
//                String value = res.getExtmapMap().get("send_wa");
//                if (!TextUtils.isEmpty(value)) {
//                    if (value.equals("true")) {
//                        tmp = true;
//                    }
//                }
//            }
//            final boolean isSendToWhatapp = tmp;
//            AuthCore.setSessionData(res.getSessiondata());
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = eTime - bTime;
//                response.mEventType = "SendSmsReq/quic";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//                response.mUserInfo = userPhoneNumber;
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
//
//                CHidoReport.getInstance().report2Hido(response);
//                CHidoReport.getInstance().report2Metric(response);
//            }
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onSuccess(0, isSendToWhatapp);
//                }
//            });
//        } else if (res.getErrcode() == Errcode.NEXT_VER) {
//            //需要二次验证
//            ALog.e(fun + "需要二次验证");
//            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
//            final SendSmsRsp resp = res;
//            final NextVerify nextVerify = new NextVerify();
//            nextVerify.mDynVer = res.getDynVer();
//            AuthCore.setSessionData(res.getSessiondata());
//            final int errCode = res.getErrcodeValue();
//            final String errDescription = res.getDescription();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    Runnable runnable = new Runnable() {
//                        @Override
//                        public void run() {
//                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
//                        }
//                    };
//                    NextVerifyUtils.getSms(context, 0, resp, userPhoneNumber,
//                            smsType, smsLength, callback, runnable, token);
////                    onNext(0, errCode, errDescription, nextVerify);
//                }
//            });
//
//        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
//            //二次验证码失败
//            final SendSmsRsp resp = res;
//            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
//            final NextVerify nextVerify = new NextVerify();
//            nextVerify.mDynVer = res.getDynVer();
//            if (TextUtils.isEmpty(nextVerify.mDynVer)) {
//                ALog.e(fun + "二次验证码失败");
//            } else {
//                ALog.e(fun + "二次验证码失败，需要再次验证");
//            }
//            AuthCore.setSessionData(res.getSessiondata());
//            final int errCode = res.getErrcodeValue();
//            final String errDescription = res.getDescription();
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    Runnable runnable = new Runnable() {
//                        @Override
//                        public void run() {
//                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
//                        }
//                    };
//                    NextVerifyUtils.getSms(context, 0, resp, userPhoneNumber,
//                            smsType, smsLength, callback, runnable, token);
////                    onNext(0, errCode, errDescription, nextVerify);
//                }
//            });
//
//        } else {
//            AuthCore.setSessionData(res.getSessiondata());
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onGetSmsFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
//                    res.getErrcodeValue(), res.getDescription());
//        }
//        return quicResult;
//    }
//
//    private void reportNext(int errType, int errCode, String description) {
//        long eTime = System.currentTimeMillis();
//        if (NetworkUtil.isNetworkConnected()) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "SendSmsReq/quic";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = userPhoneNumber;
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onGetSmsFailed(long bTime, int errType, int errCode, String description) {
//        onGetSmsFailed(bTime, traceId, errType, errCode, description);
//    }
//
//    private void onGetSmsFailed(long bTime, String traceId, final int errType, final int errCode,
//                                final String description) {
//        long eTime = System.currentTimeMillis();
//
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "SendSmsReq/quic";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = userPhoneNumber;
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//
//        return;
//    }
//
//    @Override
//    public void onSuccess(int requestId, boolean isSendToWhatapp) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId, isSendToWhatapp);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onNext(requestId, authCode, authDesc, dynVerify);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
