package com.yy.platform.loginlite;

import android.content.Context;
import android.text.TextUtils;

import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.SendSmsReq;
import com.yy.platform.loginlite.proto.SendSmsRsp;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/11.
 */

public class GetSmsHttp extends BaseHttp implements IGetSmsCallback {
    private static final String fun = "GetSms using http ";
    private long bTime;
    private String token;

    public GetSmsHttp(Context context, long sTime, String userPhoneNumber, String smsType,
                      String smsLength, String dynCode, String token, IGetSmsCallback callback) {
        super(callback);
        this.context = context;
        this.userPhoneNumber = userPhoneNumber;
        this.smsType = smsType;
        this.smsLength = smsLength;
        this.dynCode = dynCode;
        this.callback = callback;
        this.token = token;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;
    }

    public int execute() {
        bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);
        SendSmsReq smsReq = SendSmsReq.newBuilder()
                .setUser(userPhoneNumber)
                .setSmsType((smsType == null || smsType.isEmpty()) ? "0" : smsType)
                .setPrheader(AuthInfo.getHeader())
                .setCodelength((smsLength == null || smsLength.length() == 0) ? "6" : smsLength)
                .setDynCode(dynCode == null ? "" : dynCode)
                .putExtmap("whatsapptoken", token == null ? "" : token)
                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
                .build();

        traceId = UUID.randomUUID().toString();
        String url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginSendSms";
        ALog.i(fun + "userPhoneNumber:" + userPhoneNumber
                + ", smsType:" + smsType + ", smsLength:" + smsLength +
                ", traceId:" + traceId + ", url: " + url);
        if (!TextUtils.isEmpty(dynCode)) {
            ALog.e(fun + "二次验证成功");
        }

        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "LoginSendSms");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("Uid", userPhoneNumber);
            conn.addRequestProperty("ServiceName", "UdbApp.LoginServer.LoginObj");
            conn.addRequestProperty("FunctionName", "LoginSendSms");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
            conn.addRequestProperty("InstId", "LoginSendSms");
            conn.addRequestProperty("ServerId", "LoginSendSms");

            OutputStream os = conn.getOutputStream();
            smsReq.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            onGetSmsFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    quicHttp.getResponseCode(), errInfo, callback);
                if (conn != null) {
                    conn.disconnect();
                }
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            ALog.i(fun + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
//            onGetSmsFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
            return quicResult;
        }

        SendSmsRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = SendSmsRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onGetSmsFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        ALog.i(fun + "success,phoNo=" + userPhoneNumber +
                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            boolean tmp = false;
            if (res.getExtmapMap() != null) {
                String value = res.getExtmapMap().get("send_wa");
                if (!TextUtils.isEmpty(value)) {
                    if (value.equals("true")) {
                        tmp = true;
                    }
                }
            }
            final boolean isSendToWhatapp = tmp;
            AuthCore.setSessionData(res.getSessiondata());
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "SendSmsReq/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = userPhoneNumber;
                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;

                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }

            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, isSendToWhatapp);
                }
            });
        } else if (res.getErrcode() == Errcode.NEXT_VER) {
            //需要二次验证
            ALog.e(fun + "需要二次验证");
            final SendSmsRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.getSms(context, 0, resp, userPhoneNumber,
                            smsType, smsLength, callback, runnable, token);
//                    onNext(0, errCode, errDescription, nextVerify);
                }
            });

        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
            //二次验证码失败
            final SendSmsRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            if (TextUtils.isEmpty(nextVerify.mDynVer)) {
                ALog.e(fun + "二次验证码失败");
            } else {
                ALog.e(fun + "二次验证码失败，需要再次验证");
            }
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.getSms(context, 0, resp, userPhoneNumber,
                            smsType, smsLength, callback, runnable, token);
                }
            });

        } else {
            AuthCore.setSessionData(res.getSessiondata());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onGetSmsFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
        return quicResult;
    }

    private void reportNext(int errType, int errCode, String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2()) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "SendSmsReq/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }
    }

    public void onGetSmsFailed(long bTime, int errType, int errCode, String description) {
        onGetSmsFailed(bTime, traceId, errType, errCode, description);
    }

    private void onGetSmsFailed(long bTime, String traceId, final int errType, final int errCode,
                                final String description) {
        long eTime = System.currentTimeMillis();

        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "SendSmsReq/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }
        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });

        return;
    }

    private String userPhoneNumber;
    private String smsType;
    private String smsLength;
    private String dynCode;
    private IGetSmsCallback callback;
    private String traceId;
    private Context context;
    private HttpURLConnection conn = null;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    private long startTime = 0;
    private boolean isTimeout = false;
    private Lock callbackLock = null;

    @Override
    public void onSuccess(int requestId, boolean isSendToWhatapp) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, isSendToWhatapp);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, authCode, authDesc, dynVerify);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
