package com.yy.platform.loginlite;

import android.content.Context;
import android.text.TextUtils;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.SendSmsReq;
import com.yy.platform.loginlite.proto.SendSmsRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.ThreadManager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/11.
 */

public class GetSmsByOkHttp extends BaseOkHttp {
    private static final String fun = "GetSms ";
    private long bTime;
    private String token;
    private String path;
    private SendSmsReq smsReq;
    private Map<String, String> map;
    private int timeout;


    public GetSmsByOkHttp(
            int timeout, Context context, long sTime, String userPhoneNumber, String smsType,
            String smsLength, String dynCode, String token, IGetSmsCallback callback
    ) {
        this.timeout = timeout;
        this.context = context;
        this.userPhoneNumber = userPhoneNumber;
        this.smsType = smsType;
        this.smsLength = smsLength;
        this.dynCode = dynCode;
        this.callback = callback;
        this.token = token;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        path = "UdbApp.LoginServer.LoginObj/LoginSendSms";
        smsReq = SendSmsReq.newBuilder()
                .setUser(userPhoneNumber)
                .setSmsType((smsType == null || smsType.isEmpty()) ? "0" : smsType)
                .setPrheader(AuthInfo.getHeader())
                .setCodelength((smsLength == null || smsLength.length() == 0) ? "6" : smsLength)
                .setDynCode(dynCode == null ? "" : dynCode)
                .putExtmap("whatsapptoken", token == null ? "" : token)
                .setSessiondata(AuthCore.getSessionData() == null ? "" : AuthCore.getSessionData())
                .build();
        map = new HashMap<>();

        map.put("Context", "LoginSendSms");
        map.put("AppId", AuthInfo.getAppId());
        map.put("Uid", userPhoneNumber);
        map.put("ServiceName", "UdbApp.LoginServer.LoginObj");
        map.put("FunctionName", "LoginSendSms");
        map.put("ProtoType", "http");
//        map.put("InstId", "LoginSendSms");
//        map.put("ServerId", "LoginSendSms");
        tag = fun;
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        ALog.i(fun + "userPhoneNumber:" + userPhoneNumber + ", smsType:" + smsType +
                ", smsLength:" + smsLength);
        if (!TextUtils.isEmpty(dynCode)) {
            ALog.e(fun + "二次验证成功");
        }
        executeInner(path, map, smsReq.toByteArray(), timeout);
    }

    private void reportNext(int errType, int errCode, String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

//            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }
    }

    private void onGetSmsFailed(long bTime, final int errType, final int errCode,
                                final String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = userPhoneNumber;

//            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }
        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private String userPhoneNumber;
    private String smsType;
    private String smsLength;
    private String dynCode;
    private IGetSmsCallback callback;
    private Context context;
    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
    private long startTime;
    private Lock callbackLock;

    private void onSuccess(int requestId, boolean isSendToWhatapp) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, isSendToWhatapp);
        }
        callback = null;
        callbackLock.unlock();
    }


    private void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, authCode, authDesc, dynVerify);
        }
        callback = null;
        callbackLock.unlock();
    }


    private void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    private String getEventType() {
        return compose(EventTypeUtils.getSms);
    }

    @Override
    public void onSuccess(Call call, byte[] data, int httpCode, long useTime) {
        SendSmsRsp res;
        try {
            res = SendSmsRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String msg = e.getMessage();
            String errInfo = fun + "IOException, err:" + msg + ", code: " + httpCode;
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpCode, CodeUtils.getSms);
            onGetSmsFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code, msg);
            return;
        }

        ALog.i(fun + "success,phoNo=" + userPhoneNumber +
                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            boolean tmp = false;
            if (res.getExtmapMap() != null) {
                String value = res.getExtmapMap().get("send_wa");
                if (!TextUtils.isEmpty(value)) {
                    if (value.equals("true")) {
                        tmp = true;
                    }
                }
            }
            final boolean isSendToWhatapp = tmp;
            AuthCore.setSessionData(res.getSessiondata());
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (bTime > 0) {
                CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                report.mRtt = eTime - bTime;
                report.mEventType = getEventType();
                report.mSucceed = 0;
                report.mErrType = 0;
                report.mErrCode = 0;
                report.mTraceId = traceId;
                report.mChannel = ChannelName.HTTP;
                report.mUserInfo = userPhoneNumber;
                report.mQuicResult = quicResult;
                report.mTotalRtt = eTime - startTime;

                CHidoReport.getInstance().report2Hido(report);
                CHidoReport.getInstance().report2Metric(report);
            }

            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, isSendToWhatapp);
                }
            });
        } else if (res.getErrcode() == Errcode.NEXT_VER) {
            //需要二次验证
            ALog.e(fun + "需要二次验证");
            final SendSmsRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.getSms(context, 0, resp, userPhoneNumber,
                            smsType, smsLength, callback, runnable, token);
//                    onNext(0, errCode, errDescription, nextVerify);
                }
            });

        } else if (res.getErrcode() == Errcode.VCODE_ERR) {
            //二次验证码失败
            final SendSmsRsp resp = res;
            quicResult = CHidoReport.QuicResult.AUTH_CONTINUE;
            final NextVerify nextVerify = new NextVerify();
            nextVerify.mDynVer = res.getDynVer();
            if (TextUtils.isEmpty(nextVerify.mDynVer)) {
                ALog.e(fun + "二次验证码失败");
            } else {
                ALog.e(fun + "二次验证码失败，需要再次验证");
            }
            AuthCore.setSessionData(res.getSessiondata());
            final int errCode = res.getErrcodeValue();
            final String errDescription = res.getDescription();
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            reportNext(ResCodeDef.Type.AUTH_SRV_CODE, errCode, errDescription);
                        }
                    };
                    NextVerifyUtils.getSms(context, 0, resp, userPhoneNumber,
                            smsType, smsLength, callback, runnable, token);
                }
            });
        } else {
            AuthCore.setSessionData(res.getSessiondata());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onGetSmsFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }

    @Override
    public void onFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.AUTH_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.getSms);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onGetSmsFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.CONNECT_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.getSms);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onGetSmsFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }
}
