package com.yy.platform.loginlite;

import com.yy.platform.loginlite.utils.ServiceUrls;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by chenkaicai on 2019/7/10.
 */
public class FindOpenidHttp {
    private String url;
    private long appid;
    private long uid;
    private String otp;
    private int code;

    public FindOpenidHttp(String url, long appid, long uid, String otp) {
        this.url = url;
        this.appid = appid;
        this.uid = uid;
        this.otp = otp;
    }

    public String[] run() {
        BufferedReader in = null;
        String result = "";
        HttpURLConnection conn = null;
        InputStream is = null;
        String requestUrl = url + "?appid=" + appid + "&uid=" + uid + "&otp=" + otp;
        ALog.i("find openId url: " + requestUrl);
        try {
            URL httpURL = new URL(requestUrl);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.GET);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.connect();
            code = conn.getResponseCode();
            ALog.i("find openId code: " + code);
            if (code != 200) {
                return new String[]{"" + code, "request fail"};
            }
            is = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
            ALog.i("find openId result: " + result);
            return new String[]{"" + code, result};
        } catch (Exception e) {
            e.printStackTrace();
            return new String[]{"-1", e.getMessage()};
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public int getCode() {
        return code;
    }
}
