package com.yy.platform.loginlite;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;

import com.yy.platform.loginlite.utils.DensityUtil;
import com.yy.platform.outudb.R;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Created by ChenQiang on 2020/4/13
 * <p>
 * YY.Inc
 */
public class DialogActivity extends Activity {

    private WebView mWebView;
    private String tag = "native://webview?";
    private boolean isVerify = false;
    private Handler mHandler = new Handler();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setFinishOnTouchOutside(true);
        setContentView(R.layout.activity_dialog);

        isVerify = false;
        Intent intent = getIntent();

        mWebView = findViewById(R.id.webview_verify);
        mWebView.setBackgroundColor(0);

        int height = DensityUtil.getWindowHeight(DialogActivity.this);
        if (height > 0) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) mWebView.getLayoutParams();
            lp.height = height >> 1;
            lp.width = LinearLayout.LayoutParams.MATCH_PARENT;
            mWebView.setLayoutParams(lp);
        }

        String html = "";
        try {
            InputStream is = getAssets().open("yy_login_h5_validation.html");
            StringBuilder builder = new StringBuilder();
            InputStreamReader inputReader = new InputStreamReader(is);
            BufferedReader bufReader = new BufferedReader(inputReader);
            String line;
            while ((line = bufReader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            html = builder.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }

        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(tag)) {
//                    String value = url.substring(tag.length());
//                    String[] splits = value.split("=");
//                    if (splits != null && splits.length == 2) {
//                        if (splits[1] != null && !splits[1].equals("-1")) {
//                             // Intent data = new Intent();
//                            // data.putExtra("token", splits[1]);
//                            // setResult(RESULT_OK, data);
//                            finish();
//                        }
//                    }
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });

        mWebView.getSettings().setSupportZoom(true);

        mWebView.getSettings().setJavaScriptEnabled(true);
        mWebView.getSettings().setBuiltInZoomControls(false);
        mWebView.getSettings().setUseWideViewPort(true);
        mWebView.getSettings().setDomStorageEnabled(true);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            mWebView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }

        if (intent != null) {
            // 二次验证逻辑
            String jsFunction = intent.getStringExtra("function");
            ALog.i("jsFunction: " + jsFunction);
            if (!TextUtils.isEmpty(jsFunction)) {
                isVerify = true;
                html = html.replace("%s", jsFunction);
                mWebView.loadData(html, "text/html", "utf-8");
                mWebView.addJavascriptInterface(new JSInterface(), "jsi");
            }

            // 第三方登录绑定手机号码
            String url = intent.getStringExtra("url");
            ALog.i("url: " + url);
            if (!TextUtils.isEmpty(url)) {
                isVerify = false;
                mWebView.setBackgroundColor(Color.parseColor("#FFFFFF"));
                mWebView.addJavascriptInterface(new JSInterface(), "AndroidJSInterfaceV2");
                mWebView.loadUrl(url);
            }
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        mWebView.onResume();
        mWebView.resumeTimers();
    }

    @Override
    protected void onPause() {
        super.onPause();
        mWebView.onPause();
        mWebView.pauseTimers();
    }

    @Override
    public void onDestroy() {
        Event.Inform inform = Event.Inform.failOf();
        Event.getInstance().sendAll(inform);
        super.onDestroy();

        mHandler.removeCallbacksAndMessages(null);

        ViewGroup group = (ViewGroup) mWebView.getParent();
        if (group != null) {
            group.removeView(mWebView);
        }
        mWebView.stopLoading();
        // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
        mWebView.getSettings().setJavaScriptEnabled(false);
        mWebView.clearHistory();
        mWebView.clearView();
        mWebView.removeAllViews();
        mWebView.setTag(null);
        mWebView.destroyDrawingCache();
        try {
            mWebView.destroy();
            mWebView = null;
        } catch (Throwable ex) {
            ALog.i(ex.getMessage());
        }
    }

    @SuppressWarnings("unused")
    private final class JSInterface {
        /**
         * 注意这里的@JavascriptInterface注解， target是4.2以上都需要添加这个注解，否则无法调用
         */
        @JavascriptInterface
        public void verifyCallback(String verifycode) {
            ALog.i("verifyCallback: " + verifycode);
            if (!TextUtils.isEmpty(verifycode)) {
                Event.Inform<Event.VerifyBean> inform = new Event.Inform<>();
                inform.code = 0;

                Event.VerifyBean bean = new Event.VerifyBean();
                bean.dynCode = verifycode;

                inform.data = bean;
                Event.getInstance().send(inform);
                finish();
            }
        }


        /**
         * js返回给android端的数据：
         * {
         * "credit": "testcredit",//登录凭证
         * "uid": "1234567",//用户uid
         * "user_status":"0",//0代表首次登陆，1代表非首次登陆
         * "thirdData": {
         * "unionid": "u1",//第三方唯一标识，可空(qq、微信登录有值)
         * "openid": "o1",//第三方openid
         * "nickname": "xiaoming",//第三方用户昵称，可空
         * "sex": "0",//第三方用户性别，可空
         * "avatar": "http://test.com/abc.jpg"//第三方用户头像，可空
         * }
         *
         * @param module
         * @param funcName
         * @param jsonStr
         * @param callback
         */
        @JavascriptInterface
        public void invoke(String module, String funcName, String jsonStr, String callback) {
            ALog.i("module: " + module + ",funcName" + funcName + ",jsonStr:" + jsonStr);
            if (module.equals("ui") && funcName.equals("lgnBindMobileSuccess")) {
                try {
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    String uid = jsonObject.getString("uid");
                    String credit = jsonObject.getString("credit");
                    if (TextUtils.isEmpty(uid) || TextUtils.isEmpty(credit)) {
                        return;
                    }
                    Event.Inform<Event.BindPhoneBean> inform = new Event.Inform<>();
                    inform.code = 10;

                    Event.BindPhoneBean bean = new Event.BindPhoneBean();
                    bean.uid = uid;
                    bean.credit = credit;
                    bean.json = jsonStr;

                    inform.data = bean;
                    Event.getInstance().send(inform);
                    finish();
                } catch (Exception e) {
                    e.printStackTrace();
                    ALog.i("exception: " + e.getMessage());
                }
            }
        }
    }
}