//package com.yy.platform.loginlite;
//
//import com.yy.platform.loginlite.proto.CreditLoginReq;
//import com.yy.platform.loginlite.proto.CreditLoginRsp;
//import com.yy.platform.loginlite.proto.Errcode;
//import com.yy.platform.loginlite.proto.ProtoHeader;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/11.
// */
//
//public class CreditLoginQuic implements ICreditLoginCallback {
//
//    private long yyuid;
//    private CreditLoginCallbackProxy callback;
//    private IQuicHandler quicHttp;
//    private String traceId;
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//    private static final String fun = "CreditLogin using quic ";
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//    private long startTime;
//    private boolean isTimeout = false;
//    private Lock callbackLock;
//    private ProtoHeader header;
//
//    public CreditLoginQuic(
//            IQuicHandler handler,
//            long sTime,
//            long yyuid,
//            ProtoHeader header,
//            CreditLoginCallbackProxy callback
//    ) {
//        this.quicHttp = handler;
//        this.yyuid = yyuid;
//        this.callback = callback;
//        this.header = header;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int run() {
//        traceId = UUID.randomUUID().toString();
//        long bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        String credit = AuthInfo.getCredit(yyuid);
//        if (credit == null) {
//            credit = "";
//        }
//
//        CreditLoginReq creditLoginReq = CreditLoginReq.newBuilder()
//                .setUser(String.valueOf(yyuid))
//                .setCredit(credit)
//                .setPrheader(header)
//                .build();
//
//        String url = ServiceUrls.getQuitUrl() + "UdbApp.LoginServer.LoginObj/LoginByCredit";
//        ALog.i(fun + "yyuid:" + yyuid + ", traceId: " + traceId + ", url: " + url);
//
//        quicHttp.init();
//        HashMap<String, String> header = new HashMap<>();
//        header.put("Context", "creditLogin");
//        header.put("AppId", AuthInfo.getAppId());
//        header.put("Uid", String.valueOf(yyuid));
//        header.put("ServiceName", "UdbApp.LoginServer.LoginObj");
//        header.put("FunctionName", "LoginByCredit");
//        header.put("TraceId", traceId);
//        header.put("ProtoType", "Quic");
//        header.put("InstId", "creditLogin");
//        header.put("ServerId", "creditLogin");
//
//        try {
//            quicHttp.connect(url, "POST", header, creditLoginReq.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            ALog.i(fun + "connect exception, " + e.getMessage());
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onCreditLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            ALog.i(fun + "getResponseCode exception, " + e.getMessage());
//        }
//
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            String errInfo = fun + "recvResponse code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            String errInfo = fun + "connect err code:" + code;
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onCreditLoginFailed( bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo);
//            return quicResult;
//        }
//
//        CreditLoginRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = CreditLoginRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onCreditLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//
//        ALog.i(fun + "success,uid=" + yyuid +
//                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//
//        if (res.getErrcode() == Errcode.SUCCESS) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//            NetworkStrategy.getInstance().setQuicStatus(true);
//            NetworkStrategy.getInstance().setQuicTime(eTime - startTime);
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = eTime - bTime;
//                response.mEventType = "creditLogin";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//                response.mUserInfo = String.valueOf(yyuid);
//
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
//
//                callback.reportSuccess(response);
//            }
//            final CreditLoginRsp resp = res;
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    final YYInfo info = new YYInfo();
//                    callback.saveAuthInfo(resp, info, ChannelName.QUIC);
//                    onSuccess(0, info);
//                }
//            });
//
//        } else {
//            quicResult = (CHidoReport.QuicResult.AUTH_ERROR);
//            onCreditLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
//                    res.getErrcodeValue(), res.getDescription());
//        }
//        return quicResult;
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onCreditLoginFailed(long bTime, int errType, int errCode, String description) {
//        onCreditLoginFailed(bTime, traceId, errType, errCode, description);
//    }
//
//    private void onCreditLoginFailed(long bTime, String traceId, final int errType,
//                                     final int errCode,
//                                     final String description) {
//        long eTime = System.currentTimeMillis();
//        NetworkStrategy.getInstance().setQuicStatus(false);
//        NetworkStrategy.getInstance().setQuicTime(eTime - startTime);
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "creditLogin";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = String.valueOf(yyuid);
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//
//            callback.addFailResponse(response);
//        }
//
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//
//        return;
//    }
//
//    @Override
//    public void onSuccess(int requestId, YYInfo uinfo) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId, uinfo, ChannelName.QUIC);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onNext(int requestId, NextVerify dynVerify) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onNext(requestId, dynVerify, ChannelName.QUIC);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc, ChannelName.QUIC);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
