package com.yy.platform.loginlite;

import android.os.Handler;
import android.os.Looper;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.CreditLoginReq;
import com.yy.platform.loginlite.proto.CreditLoginRsp;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.ProtoHeader;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.HttpClient;
import com.yy.platform.loginlite.utils.HttpClient.HttpResponse;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/11.
 */
public class CreditLoginHttp1 implements ICreditLoginCallback, ITask {
    private static final String fun = "CreditLogin using http ";
    private CreditLoginReq creditLoginReq;
    private String url;
    private Map<String, String> headers;
    private final static int RETRY = HttpClient.RETRY;
    private final static int DURATION = HttpClient.DURATION;
    private volatile int index = 0;
    private long yyuid;
    private long startTime;
    private Lock callbackLock;
    private volatile ICreditLoginCallback callback;
    private String traceId;
    private int httpResult = CHidoReport.QuicResult.ENABLE_QUIC;
    private volatile boolean isStop = false;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private volatile int networkError = 0;
    private int timeout;

    public CreditLoginHttp1(
            int timeoutTmp,
            long sTime,
            long yyuid,
            ProtoHeader header,
            ICreditLoginCallback callback
    ) {
        this.timeout = timeoutTmp;
        this.yyuid = yyuid;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        String credit = AuthInfo.getCredit(yyuid);
        if (credit == null) {
            credit = "";
        }
        creditLoginReq = CreditLoginReq.newBuilder()
                .setUser(String.valueOf(yyuid))
                .setCredit(credit)
                .setPrheader(header)
                .build();
        url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginByCredit";
        headers = new HashMap<>();
        headers.put("Context", "creditLogin");
        headers.put("AppId", AuthInfo.getAppId());
        headers.put("Uid", String.valueOf(yyuid));
        headers.put("ServiceName", "UdbApp.LoginServer.LoginObj");
        headers.put("FunctionName", "LoginByCredit");
        headers.put("ProtoType", "http");
        headers.put("InstId", "creditLogin");
        headers.put("ServerId", "creditLogin");
    }

    private void execute() {
        synchronized (CreditLoginHttp1.class) {
            if (isStop) {
                ALog.e("CreditLoginHttp stop");
                return;
            }
        }
        if (!NetworkUtil.isNetworkConnected2()) {
            networkError = networkError + 1;
            ALog.e("network error " + networkError);
        }
        index++;
        traceId = UUID.randomUUID().toString();
        headers.put("TraceId", traceId);
        long bTime = System.currentTimeMillis();

        ALog.i(fun + "yyuid:" + yyuid + ", traceId: " + traceId + ", timeout: " +
                timeout + ", url: " + url);
        HttpResponse httpResponse = HttpClient.post(url, headers, timeout, timeout,
                creditLoginReq.toByteArray(), fun);
        if (httpResponse == null) {
            throw new IllegalArgumentException("url, header or data maybe is null");
        }
        long useTime = System.currentTimeMillis() - startTime;
        ALog.e(fun + "total time " + useTime);
        if (httpResponse.needRetry) {
            long perTime = System.currentTimeMillis() - bTime;
            int left = (int) (HttpClient.PERTIME - perTime);
            ALog.e(fun + "retry " + index + ", one time " + left);
            if (index < RETRY && useTime < DURATION && networkError < 2) {
                if (left <= 0) {
                    execute();
                } else {
                    try {
                        Thread.sleep(1000);
                        execute();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        ALog.e(fun + "fail, code " + httpResponse.errorCode);
                        httpResult = httpResponse.errorCode;
                        int code = CodeUtils.makeCode(httpResponse.httpCode, CodeUtils.creditLogin);
                        onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code,
                                "network error");
                    }
                }
//                mHandler.postDelayed(new Runnable() {
//                    @Override
//                    public void run() {
//                        ThreadManager.executeOnNetWorkThread(new Runnable() {
//                            @Override
//                            public void run() {
//                                execute();
//                            }
//                        });
//                    }
//                }, per);
            } else {
                ALog.e(fun + "fail, code " + httpResponse.errorCode);
                httpResult = httpResponse.errorCode;
                int code = CodeUtils.makeCode(httpResponse.httpCode, CodeUtils.creditLogin);
                onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code,
                        "network error");
            }
            return;
        }
        CreditLoginRsp res;
        try {
            res = CreditLoginRsp.parseFrom(httpResponse.responseData);
        } catch (InvalidProtocolBufferException e) {
            httpResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "parse InvalidProtocolBufferException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpResponse.httpCode, CodeUtils.creditLogin);
            onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return;
        }
        ALog.i(fun + "success,uid=" + yyuid +
                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());
        if (res.getErrcode() == Errcode.SUCCESS) {
            httpResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();

            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "creditLogin/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = String.valueOf(yyuid);

                response.mQuicResult = httpResult;
                response.mTotalRtt = eTime - startTime;

                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }
            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            //单位s
            info.mTS = res.getServerTime();
            info.mIsNewUser = false;
            info.mUrl = res.getUrl();
            info.extjsstr = res.getExtjsstr();
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);

            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else {
            httpResult = (CHidoReport.QuicResult.AUTH_ERROR);
            onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }

    private void onCreditLoginFailed(long bTime, final int errType, final int errCode,
                                     final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "creditLogin/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = String.valueOf(yyuid);
            response.mQuicResult = httpResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    @Override
    public void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, dynVerify);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void cancel() {
        isStop = true;
        callback = null;
    }

    @Override
    public void run() {
        execute();
    }
}
