package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.CreditLoginReq;
import com.yy.platform.loginlite.proto.CreditLoginRsp;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.ProtoHeader;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/11.
 */

public class CreditLoginHttp implements ICreditLoginCallback {
    private static final String fun = "CreditLogin using http ";

    private ProtoHeader header;

    public CreditLoginHttp(long sTime, long yyuid, ProtoHeader header, CreditLoginCallbackProxy callback) {
        this.yyuid = yyuid;
        this.callback = callback;
        this.header = header;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;
    }

    public int run() {
        traceId = UUID.randomUUID().toString();
        long bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);

        String credit = AuthInfo.getCredit(yyuid);
        if (credit == null) {
            credit = "";
        }
        CreditLoginReq creditLoginReq = CreditLoginReq.newBuilder()
                .setUser(String.valueOf(yyuid))
                .setCredit(credit)
                .setPrheader(header)
                .build();

        String url = ServiceUrls.getHttpUrl() + "UdbApp.LoginServer.LoginObj/LoginByCredit";
        ALog.i(fun + "yyuid:" + yyuid + ", traceId: " + traceId + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "creditLogin");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("Uid", String.valueOf(yyuid));
            conn.addRequestProperty("ServiceName", "UdbApp.LoginServer.LoginObj");
            conn.addRequestProperty("FunctionName", "LoginByCredit");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
//            conn.addRequestProperty("InstId", "creditLogin");
//            conn.addRequestProperty("ServerId", "creditLogin");

            OutputStream os = conn.getOutputStream();
            creditLoginReq.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            onCreditLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    quicHttp.getResponseCode(), errInfo, callback);
                if (conn != null) {
                    conn.disconnect();
                }
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            ALog.i(fun + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
//            onCreditLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
            return quicResult;
        }

        CreditLoginRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = CreditLoginRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onCreditLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        ALog.i(fun + "success,uid=" + yyuid +
                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();

            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "creditLogin";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;
                response.mUserInfo = String.valueOf(yyuid);

                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;

                callback.reportSuccess(response);
            }
            final CreditLoginRsp resp = res;
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    final YYInfo info = new YYInfo();
                    callback.saveAuthInfo(resp, info, ChannelName.HTTP);
                    onSuccess(0, info);
                }
            });

        } else {
            quicResult = (CHidoReport.QuicResult.AUTH_ERROR);
            onCreditLoginFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
        return quicResult;
    }

    public void onCreditLoginFailed(long bTime, int errType, int errCode, String description) {
        onCreditLoginFailed(bTime, traceId, errType, errCode, description);
    }

    private void onCreditLoginFailed(long bTime, String traceId, final int errType, final int errCode,
                                     final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "creditLogin";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = String.valueOf(yyuid);

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;

            callback.addFailResponse(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });

        return;
    }

    private long yyuid;
    private CreditLoginCallbackProxy callback;

    private HttpURLConnection conn = null;
    private String traceId;

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    private long startTime;
    private Lock callbackLock = null;

    @Override
    public void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo, ChannelName.HTTP);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, dynVerify, ChannelName.HTTP);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc, ChannelName.HTTP);
        }
        callback = null;
        callbackLock.unlock();
    }
}
