package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.CreditLoginRsp;
import com.yy.platform.loginlite.utils.UserInfoUtils;

public class CreditLoginCallbackProxy extends CallbackProxy<ICreditLoginCallback> {

    private volatile boolean isSaveInfo = false;

    public CreditLoginCallbackProxy(ICreditLoginCallback callback) {
        super(callback);
    }

    public void saveAuthInfo(CreditLoginRsp resp, YYInfo info, String channel) {
        UserInfoUtils.unPack(resp.getUserData(), info);
        //单位s
        info.mTS = resp.getServerTime();
        info.mIsNewUser = false;
        info.mUrl = resp.getUrl();
        info.extjsstr = resp.getExtjsstr();

        if (count == 1) {
            ALog.i(channel + " creditLogin save AuthInfo");
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
            AntiHelper.checkAntiCodeHw(info.mUid);
        } else {
            if (isSaveInfo) {
                return;
            }
            isSaveInfo = true;
            ALog.i(channel + " creditLogin save AuthInfo");
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
            AntiHelper.checkAntiCodeHw(info.mUid);
        }
    }

    public void onSuccess(int requestId, YYInfo uinfo, String channel) {
        if (channel.equals(ChannelName.HTTP)) {
            setHttpResult(true);
        } else if (channel.equals(ChannelName.QUIC)) {
            setQuicResult(true);
        }
        if (isSuccess()) {
            return;
        }
        setSuccess(true);
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
    }

    public void onNext(int requestId, NextVerify dynVerify, String channel) {

    }

    public void onFail(int requestId, int codeType, int resCode, String resDesc, String channel) {
        if (channel.equals(ChannelName.HTTP)) {
            setHttpResult(true);
        } else if (channel.equals(ChannelName.QUIC)) {
            setQuicResult(true);
        }
        failCount--;
        if (count == 1) {
            if (callback != null) {
                callback.onFail(requestId, codeType, resCode, resDesc);
            }
        } else {
            // 如果登录成功了
            if (isSuccess()) {
                return;
            }
            if (failCount == 0) {
                if (callback != null) {
                    callback.onFail(requestId, codeType, resCode, resDesc);
                }
                reportFail();
            }
        }
    }
}
